/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.player.UseBoneMealCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.UseBoneMealHandler;
import fuzs.universalbonemeal.init.ModRegistry;
import fuzs.universalbonemeal.network.ClientboundGrowthParticlesMessage;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.DirtBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.FruitStemBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.MyceliumBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.NetherWartBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PodzolBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PopResourceBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleGrowingPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleSpreadBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.VineBehavior;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalBoneMeal
implements ModConstructor {
    public static final String MOD_ID = "universalbonemeal";
    public static final String MOD_NAME = "Universal Bone Meal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Universal Bone Meal");
    public static final NetworkHandler NETWORK = NetworkHandler.builder((String)"universalbonemeal").registerClientbound(ClientboundGrowthParticlesMessage.class);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"universalbonemeal").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        UniversalBoneMeal.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        UseBoneMealCallback.EVENT.register(UseBoneMealHandler::onUseBoneMeal);
        TagsUpdatedCallback.EVENT.register((registryAccess, client) -> {
            if (client) {
                return;
            }
            UseBoneMealHandler.invalidate();
            CoralBehavior.invalidate();
        });
    }

    public void onCommonSetup() {
        UniversalBoneMeal.registerBonemealBehaviors();
    }

    private static void registerBonemealBehaviors() {
        UseBoneMealHandler.registerBehavior(class_2246.field_10029, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCactus);
        UseBoneMealHandler.registerBehavior(class_2246.field_10424, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSugarCane);
        UseBoneMealHandler.registerBehavior(class_2246.field_10597, VineBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowVines);
        UseBoneMealHandler.registerBehavior(class_2246.field_9974, NetherWartBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowNetherWart);
        UseBoneMealHandler.registerBehavior(Set.of(class_2246.field_46287, class_2246.field_46286), FruitStemBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowFruitStems);
        UseBoneMealHandler.registerBehavior(class_2246.field_10588, () -> new SimpleSpreadBehavior(4, 3), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowLilyPad);
        UseBoneMealHandler.registerBehavior(class_2246.field_10428, () -> new SimpleSpreadBehavior(4, 2), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDeadBush);
        UseBoneMealHandler.registerBehavior((class_6862<class_2248>)class_3481.field_15480, ModRegistry.FERTILIZER_RESISTANT_FLOWERS_BLOCK_TAG, () -> new SimpleSpreadBehavior(3, 1), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSmallFlowers);
        UseBoneMealHandler.registerBehavior((class_6862<class_2248>)class_3481.field_15483, CoralBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCorals);
        UseBoneMealHandler.registerBehavior(class_2246.field_10528, ChorusFlowerBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        UseBoneMealHandler.registerBehavior(class_2246.field_10021, ChorusPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        UseBoneMealHandler.registerBehavior(class_2246.field_10402, MyceliumBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowMycelium);
        UseBoneMealHandler.registerBehavior(Set.of(class_2246.field_10566, class_2246.field_10253, class_2246.field_10194), DirtBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDirt);
        UseBoneMealHandler.registerBehavior(class_2246.field_10520, PodzolBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowPodzol);
        UseBoneMealHandler.registerBehavior(class_2246.field_28677, () -> new PopResourceBehavior(class_2350.field_11033), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSporeBlossom);
    }

    public static class_2960 id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

