/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.handler;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.universalbonemeal.UniversalBoneMeal;
import fuzs.universalbonemeal.network.ClientboundGrowthParticlesMessage;
import fuzs.universalbonemeal.world.level.block.behavior.BoneMealBehavior;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;

public class UseBoneMealHandler {
    private static final List<AbstractBehaviorData> BONE_MEAL_BEHAVIORS = new ArrayList<AbstractBehaviorData>();
    private static Map<class_2248, BoneMealBehavior> blockToBehavior;

    public static EventResult onUseBoneMeal(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1799 itemStack) {
        BoneMealBehavior boneMealBehavior = UseBoneMealHandler.dissolve().get(blockState.method_26204());
        if (boneMealBehavior != null && boneMealBehavior.method_9651((class_4538)level, blockPos, blockState)) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (boneMealBehavior.method_9650(level, level.field_9229, blockPos, blockState)) {
                    boneMealBehavior.method_9652(serverLevel, level.field_9229, blockPos, blockState);
                }
                if (itemStack.method_7946()) {
                    itemStack.method_7934(1);
                } else if (itemStack.method_7963()) {
                    ItemHelper.hurtAndBreak((class_1799)itemStack, (int)1, (class_3218)serverLevel, null, (Consumer)Consumers.nop());
                }
                if (!(blockState.method_26204() instanceof class_2256)) {
                    UniversalBoneMeal.NETWORK.sendToAllNear((class_2382)blockPos, serverLevel, (ClientboundMessage)new ClientboundGrowthParticlesMessage(blockPos));
                }
            }
            return EventResult.ALLOW;
        }
        return EventResult.PASS;
    }

    private static Map<class_2248, BoneMealBehavior> dissolve() {
        Map<class_2248, BoneMealBehavior> map = blockToBehavior;
        if (map == null) {
            IdentityHashMap<class_2248, BoneMealBehavior> newMap = new IdentityHashMap<class_2248, BoneMealBehavior>();
            for (AbstractBehaviorData behavior : BONE_MEAL_BEHAVIORS) {
                if (!behavior.allow()) continue;
                behavior.compile(newMap);
            }
            blockToBehavior = ImmutableMap.copyOf(newMap);
            return blockToBehavior;
        }
        return map;
    }

    public static void invalidate() {
        blockToBehavior = null;
    }

    public static void registerBehavior(class_2248 block, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockBehaviorData(block, factory, config));
    }

    public static void registerBehavior(Set<class_2248> blocks, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new MultiBlockBehaviorData(blocks, factory, config));
    }

    public static void registerBehavior(class_6862<class_2248> tag, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockTagBehaviorData(tag, null, factory, config));
    }

    public static void registerBehavior(class_6862<class_2248> allowedTag, class_6862<class_2248> disallowedTag, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockTagBehaviorData(allowedTag, disallowedTag, factory, config));
    }

    private static abstract class AbstractBehaviorData {
        final BoneMealBehavior behavior;
        private final BooleanSupplier config;

        public AbstractBehaviorData(Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            this.behavior = factory.get();
            this.config = config;
        }

        public abstract void compile(Map<class_2248, BoneMealBehavior> var1);

        public boolean allow() {
            return this.config.getAsBoolean();
        }
    }

    private static class BlockBehaviorData
    extends AbstractBehaviorData {
        private final class_2248 block;

        public BlockBehaviorData(class_2248 block, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.block = block;
        }

        @Override
        public void compile(Map<class_2248, BoneMealBehavior> map) {
            map.put(this.block, this.behavior);
        }
    }

    private static class MultiBlockBehaviorData
    extends AbstractBehaviorData {
        private final Set<class_2248> targets;

        public MultiBlockBehaviorData(Set<class_2248> targets, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.targets = targets;
        }

        @Override
        public void compile(Map<class_2248, BoneMealBehavior> map) {
            for (class_2248 target : this.targets) {
                map.putIfAbsent(target, this.behavior);
            }
        }
    }

    private static class BlockTagBehaviorData
    extends AbstractBehaviorData {
        private final class_6862<class_2248> allowedTag;
        @Nullable
        private final class_6862<class_2248> disallowedTag;

        public BlockTagBehaviorData(class_6862<class_2248> allowedTag, @Nullable class_6862<class_2248> disallowedTag, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.allowedTag = allowedTag;
            this.disallowedTag = disallowedTag;
        }

        @Override
        public void compile(Map<class_2248, BoneMealBehavior> map) {
            for (class_6880 holder : class_7923.field_41175.method_40286(this.allowedTag)) {
                if (this.disallowedTag != null && holder.method_40220(this.disallowedTag)) continue;
                map.putIfAbsent((class_2248)holder.comp_349(), this.behavior);
            }
        }
    }
}

