/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.config;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import glitchcore.config.Config;
import glitchcore.util.Environment;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import sereneseasons.api.season.Season;

public class SeasonsConfig
extends Config {
    private static final class_6017 THUNDER_DELAY = class_6019.method_35017((int)12000, (int)180000);
    private static final Predicate<List<com.electronwill.nightconfig.core.Config>> SEASON_PROPERTIES_VALIDATOR = configs -> configs.stream().allMatch(c -> SeasonProperties.decode(c).isPresent());
    private static final Map<Season.SubSeason, SeasonProperties> DEFAULT_SEASON_PROPERTIES = Lists.newArrayList((Object[])new SeasonProperties[]{new SeasonProperties(Season.SubSeason.EARLY_WINTER, 0.0f, 0, -0.8f, 12000, 36000, -1, -1), new SeasonProperties(Season.SubSeason.MID_WINTER, 0.0f, 0, -0.8f, 12000, 36000, -1, -1), new SeasonProperties(Season.SubSeason.LATE_WINTER, 0.0f, 0, -0.8f, 12000, 36000, -1, -1), new SeasonProperties(Season.SubSeason.EARLY_SPRING, 6.25f, 1, -0.25f, 12000, 96000, THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.MID_SPRING, 8.33f, 1, 0.0f, 12000, 96000, THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.LATE_SPRING, 12.5f, 1, 0.0f, 12000, 96000, THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.EARLY_SUMMER, 25.0f, 1, 0.0f, 12000, 96000, THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.MID_SUMMER, 25.0f, 1, 0.0f, 12000, 96000, THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.LATE_SUMMER, 25.0f, 1, 0.0f, 12000, 96000, THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.EARLY_AUTUMN, 12.5f, 1, 0.0f, class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.MID_AUTUMN, 8.33f, 1, 0.0f, class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011()), new SeasonProperties(Season.SubSeason.LATE_AUTUMN, 6.25f, 1, -0.25f, class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), THUNDER_DELAY.method_35009(), THUNDER_DELAY.method_35011())}).stream().collect(Collectors.toMap(SeasonProperties::subSeason, v -> v));
    private static final Predicate<List<String>> RESOURCE_LOCATION_VALIDATOR = list -> {
        for (String s : list) {
            try {
                class_2960.method_60654((String)s);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    };
    public boolean generateSnowAndIce;
    public boolean changeWeatherFrequency;
    public int dayDuration;
    public int subSeasonDuration;
    public int startingSubSeason;
    public boolean progressSeasonWhileOffline;
    public boolean changeGrassColor;
    public boolean changeFoliageColor;
    public boolean changeBirchColor;
    public List<String> whitelistedDimensions;
    private static final List<String> defaultWhitelistedDimensions = Lists.newArrayList((Object[])new String[]{class_1937.field_25179.method_29177().toString()});
    private List<com.electronwill.nightconfig.core.Config> seasonProperties;
    private Supplier<Map<Season.SubSeason, SeasonProperties>> seasonPropertiesMapper;

    public SeasonsConfig() {
        super(Environment.getConfigPath().resolve("sereneseasons/seasons.toml"));
    }

    public void load() {
        this.generateSnowAndIce = (Boolean)this.add("weather_settings.generate_snow_ice", true, "Generate snow and ice during the Winter season");
        this.changeWeatherFrequency = (Boolean)this.add("weather_settings.change_weather_frequency", true, "Change the frequency of rain/snow/storms based on the season");
        this.dayDuration = (Integer)this.addNumber("time_settings.day_duration", 24000, 20, Integer.MAX_VALUE, "The duration of a Minecraft day in ticks.\nThis only adjusts the internal length of a day used by the season cycle.\nIt is intended to be used in conjunction with another mod which adjusts the actual length of a Minecraft day.");
        this.subSeasonDuration = (Integer)this.addNumber("time_settings.sub_season_duration", 8, 1, Integer.MAX_VALUE, "The duration of a sub season in days.");
        this.startingSubSeason = (Integer)this.addNumber("time_settings.starting_sub_season", 1, 0, 12, "The starting sub season for new worlds.\n0 = Random, 1 - 3 = Early/Mid/Late Spring\n4 - 6 = Early/Mid/Late Summer\n7 - 9 = Early/Mid/Late Autumn\n10 - 12 = Early/Mid/Late Winter");
        this.progressSeasonWhileOffline = (Boolean)this.add("time_settings.progress_season_while_offline", true, "If the season should progress on a server with no players online");
        this.changeGrassColor = (Boolean)this.add("aesthetic_settings.change_grass_color", true, "Change the grass color based on the current season");
        this.changeFoliageColor = (Boolean)this.add("aesthetic_settings.change_foliage_color", true, "Change the foliage colour based on the current season");
        this.changeBirchColor = (Boolean)this.add("aesthetic_settings.change_birch_color", true, "Change the birch colour based on the current season");
        this.whitelistedDimensions = (List)this.add("dimension_settings.whitelisted_dimensions", defaultWhitelistedDimensions, "Seasons will only apply to dimensons listed here", RESOURCE_LOCATION_VALIDATOR);
        List<com.electronwill.nightconfig.core.Config> defaultProperties = DEFAULT_SEASON_PROPERTIES.values().stream().map(SeasonProperties::encode).toList();
        this.seasonProperties = (List)this.add("season_properties", defaultProperties, "melt_percent is the 0-1 percentage chance a snow or ice block will melt when chosen. (e.g. 100.0 = 100%, 50.0 = 50%)\nmelt_rolls is the number of blocks randomly picked in each chunk, each tick. (High number rolls is not recommended on servers)\nmelt_rolls should be 0 if blocks should not melt in that season.\nbiome_temp_adjustment is the amount to adjust the biome temperature by from -10.0 to 10.0.\nmin_rain_time is the minimum time interval between rain events in ticks. Set to -1 to disable rain.\nmax_rain_time is the maximum time interval between rain events in ticks. Set to -1 to disable rain.\nmin_thunder_time is the minimum time interval between thunder events in ticks. Set to -1 to disable thunder.\nmax_thunder_time is the maximum time interval between thunder events in ticks. Set to -1 to disable thunder.", SEASON_PROPERTIES_VALIDATOR);
        this.seasonPropertiesMapper = Suppliers.memoize(() -> {
            HashMap<Season.SubSeason, SeasonProperties> map = new HashMap<Season.SubSeason, SeasonProperties>(DEFAULT_SEASON_PROPERTIES);
            this.seasonProperties.stream().map(SeasonProperties::decode).forEach(o -> o.ifPresent(v -> map.put(v.subSeason(), (SeasonProperties)v)));
            return map;
        });
    }

    public boolean isDimensionWhitelisted(class_5321<class_1937> dimension) {
        for (String whitelistedDimension : this.whitelistedDimensions) {
            if (!dimension.method_29177().toString().equals(whitelistedDimension)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public SeasonProperties getSeasonProperties(Season.SubSeason season) {
        return this.seasonPropertiesMapper.get().get(season);
    }

    static {
        Preconditions.checkState((boolean)DEFAULT_SEASON_PROPERTIES.keySet().containsAll(List.of(Season.SubSeason.values())));
    }

    public record SeasonProperties(Season.SubSeason subSeason, float meltChance, int meltRolls, float biomeTempAdjustment, int minRainTime, int maxRainTime, int minThunderTime, int maxThunderTime) {
        public com.electronwill.nightconfig.core.Config encode() {
            com.electronwill.nightconfig.core.Config config = com.electronwill.nightconfig.core.Config.of(LinkedHashMap::new, (ConfigFormat)InMemoryFormat.withUniversalSupport());
            config.add("season", (Object)this.subSeason.toString());
            config.add("melt_percent", (Object)Float.valueOf(this.meltChance));
            config.add("melt_rolls", (Object)this.meltRolls);
            config.add("biome_temp_adjustment", (Object)Float.valueOf(this.biomeTempAdjustment));
            config.add("min_rain_time", (Object)this.minRainTime);
            config.add("max_rain_time", (Object)this.maxRainTime);
            config.add("min_thunder_time", (Object)this.minThunderTime);
            config.add("max_thunder_time", (Object)this.maxThunderTime);
            return config;
        }

        public static Optional<SeasonProperties> decode(com.electronwill.nightconfig.core.Config config) {
            try {
                Season.SubSeason subSeason = (Season.SubSeason)config.getEnum("season", Season.SubSeason.class);
                float meltChance = ((Number)config.get("melt_percent")).floatValue();
                int rolls = config.getInt("melt_rolls");
                float biomeTempAdjustment = ((Number)config.get("biome_temp_adjustment")).floatValue();
                int minRainTime = config.getInt("min_rain_time");
                int maxRainTime = config.getInt("max_rain_time");
                int minThunderTime = config.getInt("min_thunder_time");
                int maxThunderTime = config.getInt("max_thunder_time");
                Preconditions.checkArgument((meltChance >= 0.0f && meltChance <= 100.0f ? 1 : 0) != 0);
                Preconditions.checkArgument((rolls >= 0 ? 1 : 0) != 0);
                Preconditions.checkArgument(((double)biomeTempAdjustment >= -10.0 && (double)biomeTempAdjustment <= 10.0 ? 1 : 0) != 0);
                Preconditions.checkArgument((minRainTime <= maxRainTime ? 1 : 0) != 0);
                Preconditions.checkArgument((minThunderTime <= maxThunderTime ? 1 : 0) != 0);
                return Optional.of(new SeasonProperties(subSeason, meltChance, rolls, biomeTempAdjustment, minRainTime, maxRainTime, minThunderTime, maxThunderTime));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }

        public boolean canRain() {
            return this.minRainTime != -1 && this.maxRainTime != -1;
        }

        public boolean canThunder() {
            return this.minThunderTime != -1 && this.maxThunderTime != -1;
        }
    }
}

