/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.blocks.base.asphalt.AsphaltBlock;
import com.brand.blockus.blocks.base.asphalt.AsphaltSlab;
import com.brand.blockus.blocks.base.asphalt.AsphaltStairs;
import com.brand.blockus.utils.helper.BlockFactory;
import com.brand.blockus.utils.helper.BlockOrder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2766;
import net.minecraft.class_4970;

public record AsphaltBundle(Map<class_1767, AsphaltVariants> colorMap) {
    public static Builder of() {
        return new Builder("asphalt");
    }

    public List<class_2248> all() {
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        for (class_1767 color : BlockOrder.COLOR) {
            AsphaltVariants variants = this.colorMap.get(color);
            list.add(variants.block());
            list.add(variants.stairs());
            list.add(variants.slab());
        }
        return list;
    }

    public AsphaltVariants baseColor() {
        return this.colorMap.get(class_1767.field_7963);
    }

    public static class Builder {
        private final String id;
        private Function<class_4970.class_2251, class_4970.class_2251> settings = Function.identity();

        public Builder(String id) {
            this.id = id;
        }

        public Builder settings(Function<class_4970.class_2251, class_4970.class_2251> settings) {
            this.settings = settings;
            return this;
        }

        public AsphaltBundle register() {
            EnumMap<class_1767, AsphaltVariants> colorMap = new EnumMap<class_1767, AsphaltVariants>(class_1767.class);
            for (class_1767 color : BlockOrder.COLOR) {
                String type = color.method_7792() + "_" + this.id;
                String type2 = type.replace("black_" + this.id, this.id);
                class_4970.class_2251 blockSettings = this.settings.apply(BlockFactory.create().method_51517(color).method_51368(class_2766.field_12653).method_9629(1.5f, 6.0f).method_29292());
                class_2248 block = BlockFactory.registerOf(type2, AsphaltBlock::new, blockSettings);
                class_2248 stairs = BlockFactory.registerOf(type2 + "_stairs", s -> new AsphaltStairs(block.method_9564(), (class_4970.class_2251)s), class_4970.class_2251.method_9630((class_4970)block));
                class_2248 slab = BlockFactory.registerOf(type2 + "_slab", AsphaltSlab::new, class_4970.class_2251.method_9630((class_4970)block));
                colorMap.put(color, new AsphaltVariants(block, stairs, slab));
            }
            return new AsphaltBundle(colorMap);
        }
    }

    public record AsphaltVariants(class_2248 block, class_2248 stairs, class_2248 slab) {
    }
}

