/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.blocks.base.OxidizableWallBlock;
import com.brand.blockus.utils.helper.BlockFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_4970;
import net.minecraft.class_5812;
import net.minecraft.class_5813;
import net.minecraft.class_5814;
import net.minecraft.class_5955;

public record CopperBundle(String type, class_2248 base, class_2248 block, class_2248 stairs, class_2248 slab, class_2248 wall, class_2248 blockWaxed, class_2248 stairsWaxed, class_2248 slabWaxed, class_2248 wallWaxed) {
    public static final List<CopperBundle> LIST = new ArrayList<CopperBundle>();

    public static List<CopperBundle> values() {
        return LIST;
    }

    public static Builder of(String type, OxidationType oxidation, class_2248 base) {
        return new Builder(type, oxidation, base);
    }

    public List<class_2248> allBlocks() {
        return List.of(this.block, this.blockWaxed);
    }

    public List<class_2248> allSlabs() {
        return List.of(this.slab, this.slabWaxed);
    }

    public List<class_2248> allStairs() {
        return List.of(this.stairs, this.stairsWaxed);
    }

    public List<class_2248> allWalls() {
        return List.of(this.wall, this.wallWaxed);
    }

    public List<class_2248> allUnwaxed() {
        return List.of(this.block, this.stairs, this.slab, this.wall);
    }

    public List<class_2248> allWaxed() {
        return List.of(this.blockWaxed, this.stairsWaxed, this.slabWaxed, this.wallWaxed);
    }

    public List<class_2248> all() {
        return List.of(this.block, this.stairs, this.slab, this.wall, this.blockWaxed, this.stairsWaxed, this.slabWaxed, this.wallWaxed);
    }

    public static class Builder {
        public final String type;
        public final class_2248 base;
        public final OxidationType oxidation;

        public Builder(String type, OxidationType oxidation, class_2248 base) {
            this.type = type;
            this.base = base;
            this.oxidation = oxidation;
        }

        public CopperBundle register() {
            String prefix = this.oxidation.getPrefix();
            class_5955.class_5811 oxidationLevel = this.oxidation.getLevel();
            class_2248 block = BlockFactory.registerCopy(prefix + this.type, settings -> new class_5812(this.oxidation.getLevel(), settings), this.base);
            class_2248 blockWaxed = BlockFactory.registerCopy("waxed_" + prefix + this.type, this.base);
            CopperBundle bundle = new CopperBundle(this.type, this.base, block, BlockFactory.registerCopy(prefix + BlockFactory.replaceId(this.type) + "_stairs", settings -> new class_5814(oxidationLevel, this.base.method_9564(), settings), this.base), BlockFactory.registerCopy(prefix + BlockFactory.replaceId(this.type) + "_slab", settings -> new class_5813(oxidationLevel, settings), this.base), BlockFactory.registerCopy(prefix + BlockFactory.replaceId(this.type) + "_wall", settings -> new OxidizableWallBlock(oxidationLevel, (class_4970.class_2251)settings), this.base), blockWaxed, BlockFactory.stairs(blockWaxed), BlockFactory.slab(blockWaxed), BlockFactory.wall(blockWaxed));
            LIST.add(bundle);
            return bundle;
        }
    }

    public static enum OxidationType {
        UNAFFECTED(class_5955.class_5811.field_28704, ""),
        EXPOSED(class_5955.class_5811.field_28705, "exposed_"),
        WEATHERED(class_5955.class_5811.field_28706, "weathered_"),
        OXIDIZED(class_5955.class_5811.field_28707, "oxidized_");

        private final class_5955.class_5811 oxidationLevel;
        private final String prefix;

        private OxidationType(class_5955.class_5811 oxidationLevel, String prefix) {
            this.oxidationLevel = oxidationLevel;
            this.prefix = prefix;
        }

        public class_5955.class_5811 getLevel() {
            return this.oxidationLevel;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

