/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.registry.content.bundles.BSSWBundle;
import com.brand.blockus.utils.helper.BlockBuilder;
import com.brand.blockus.utils.helper.BlockMaps;
import com.brand.blockus.utils.helper.BlockOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_4970;

public record StainedBSSWBundle(Map<class_1767, BSSWBundle> colorMap) {
    public static Builder of(String id, Map<class_1767, class_2248> baseBlockColorMap) {
        return new Builder(id, baseBlockColorMap);
    }

    public static Builder of(String id, class_2248 baseBlock) {
        return new Builder(id, Arrays.stream(BlockOrder.COLOR).collect(Collectors.toMap(color -> color, color -> baseBlock)));
    }

    public class_2248[] all() {
        ArrayList<class_2248> blocks = new ArrayList<class_2248>();
        for (BSSWBundle bsswBundle : this.colorMap.values()) {
            blocks.addAll(Arrays.asList(bsswBundle.all()));
        }
        return blocks.toArray(new class_2248[0]);
    }

    public static class Builder {
        private final String id;
        private final Map<class_1767, class_2248> baseBlockColorMap;
        private Function<class_4970.class_2251, class_4970.class_2251> settings = null;
        private boolean includeWall = true;
        private boolean useMapColor = false;

        public Builder(String id, Map<class_1767, class_2248> baseBlockColorMap) {
            this.id = id;
            this.baseBlockColorMap = baseBlockColorMap;
        }

        public Builder settings(Function<class_4970.class_2251, class_4970.class_2251> settings) {
            this.settings = settings;
            return this;
        }

        public Builder useMapColor() {
            this.useMapColor = true;
            return this;
        }

        public Builder includeWall(boolean include) {
            this.includeWall = include;
            return this;
        }

        public StainedBSSWBundle register() {
            EnumMap<class_1767, BSSWBundle> colorMap = new EnumMap<class_1767, BSSWBundle>(class_1767.class);
            for (class_1767 color : BlockOrder.COLOR) {
                String blockPath = color.method_7792() + "_" + this.id;
                class_2248 baseBlock = this.baseBlockColorMap.get(color);
                BlockBuilder blockBuilder = new BlockBuilder(baseBlock);
                if (this.settings != null) {
                    blockBuilder.settings(this.settings);
                }
                if (this.useMapColor) {
                    blockBuilder.settings(s -> s.method_31710(BlockMaps.COLOR_MAP.get(color)));
                }
                BSSWBundle bundle = BSSWBundle.of(blockPath, blockBuilder).includeWall(this.includeWall).register();
                colorMap.put(color, bundle);
            }
            return new StainedBSSWBundle(colorMap);
        }
    }
}

