/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.utils.helper;

import com.brand.blockus.utils.helper.BlockOrder;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_7923;

public class BlockMaps {
    public static final Map<class_1767, ColorData> COLOR_DATA;
    public static final Map<class_1767, class_2248> TERRACOTTA_MAP;
    public static final Map<class_1767, class_2248> GLAZED_TERRACOTTA_MAP;
    public static final Map<class_1767, class_2248> STAINED_GLASS_MAP;
    public static final Map<class_1767, class_2248> STAINED_GLASS_PANE_MAP;
    public static final Map<class_1767, class_2248> CONCRETE_MAP;
    public static final Map<class_1767, class_2248> WOOL_MAP;
    public static final Map<class_1767, class_2248> CARPET_MAP;
    public static final Map<class_1767, class_3620> COLOR_MAP;

    public static class_2248 getBlock(class_1767 color, String suffix) {
        return (class_2248)class_7923.field_41175.method_10223(class_2960.method_60656((String)(color.name().toLowerCase() + suffix)));
    }

    public static <T> Map<class_1767, T> extract(Function<ColorData, T> mapper) {
        return COLOR_DATA.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> mapper.apply((ColorData)entry.getValue())));
    }

    static {
        EnumMap<class_1767, ColorData> map = new EnumMap<class_1767, ColorData>(class_1767.class);
        for (class_1767 color : BlockOrder.COLOR) {
            map.put(color, new ColorData(BlockMaps.getBlock(color, "_terracotta"), BlockMaps.getBlock(color, "_glazed_terracotta"), BlockMaps.getBlock(color, "_stained_glass"), BlockMaps.getBlock(color, "_stained_glass_pane"), BlockMaps.getBlock(color, "_concrete"), BlockMaps.getBlock(color, "_wool"), BlockMaps.getBlock(color, "_carpet")));
        }
        COLOR_DATA = Map.copyOf(map);
        TERRACOTTA_MAP = BlockMaps.extract(ColorData::terracotta);
        GLAZED_TERRACOTTA_MAP = BlockMaps.extract(ColorData::glazedTerracotta);
        STAINED_GLASS_MAP = BlockMaps.extract(ColorData::stainedGlass);
        STAINED_GLASS_PANE_MAP = BlockMaps.extract(ColorData::stainedGlassPane);
        CONCRETE_MAP = BlockMaps.extract(ColorData::concrete);
        WOOL_MAP = BlockMaps.extract(ColorData::wool);
        CARPET_MAP = BlockMaps.extract(ColorData::carpet);
        COLOR_MAP = ImmutableMap.builder().put((Object)class_1767.field_7952, (Object)class_3620.field_16022).put((Object)class_1767.field_7967, (Object)class_3620.field_15993).put((Object)class_1767.field_7944, (Object)class_3620.field_15978).put((Object)class_1767.field_7963, (Object)class_3620.field_16009).put((Object)class_1767.field_7957, (Object)class_3620.field_15977).put((Object)class_1767.field_7964, (Object)class_3620.field_16020).put((Object)class_1767.field_7946, (Object)class_3620.field_15987).put((Object)class_1767.field_7947, (Object)class_3620.field_16010).put((Object)class_1767.field_7961, (Object)class_3620.field_15997).put((Object)class_1767.field_7942, (Object)class_3620.field_15995).put((Object)class_1767.field_7955, (Object)class_3620.field_16026).put((Object)class_1767.field_7951, (Object)class_3620.field_16024).put((Object)class_1767.field_7966, (Object)class_3620.field_15984).put((Object)class_1767.field_7945, (Object)class_3620.field_16014).put((Object)class_1767.field_7958, (Object)class_3620.field_15998).put((Object)class_1767.field_7954, (Object)class_3620.field_16030).build();
    }

    public record ColorData(class_2248 terracotta, class_2248 glazedTerracotta, class_2248 stainedGlass, class_2248 stainedGlassPane, class_2248 concrete, class_2248 wool, class_2248 carpet) {
    }
}

