/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.utils.helper;

import com.brand.blockus.registry.content.BlockusBlocks;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public enum WoodMaps {
    OAK("oak", class_2246.field_10161, class_2246.field_10119, class_2246.field_10431, class_2246.field_10519, true),
    SPRUCE("spruce", class_2246.field_9975, class_2246.field_10071, class_2246.field_10037, class_2246.field_10436, true),
    BIRCH("birch", class_2246.field_10148, class_2246.field_10257, class_2246.field_10511, class_2246.field_10366, true),
    JUNGLE("jungle", class_2246.field_10334, class_2246.field_10617, class_2246.field_10306, class_2246.field_10254, true),
    ACACIA("acacia", class_2246.field_10218, class_2246.field_10031, class_2246.field_10533, class_2246.field_10622, true),
    DARK_OAK("dark_oak", class_2246.field_10075, class_2246.field_10500, class_2246.field_10010, class_2246.field_10244, true),
    MANGROVE("mangrove", class_2246.field_37577, class_2246.field_37564, class_2246.field_37545, class_2246.field_37548, true),
    CHERRY("cherry", class_2246.field_42751, class_2246.field_42746, class_2246.field_42729, class_2246.field_42732, true),
    BAMBOO("bamboo", class_2246.field_40294, class_2246.field_40292, null, null, true),
    RAW_BAMBOO("raw_bamboo", BlockusBlocks.RAW_BAMBOO.planks(), BlockusBlocks.RAW_BAMBOO.slab(), null, null, true),
    WHITE_OAK("white_oak", BlockusBlocks.WHITE_OAK.planks(), BlockusBlocks.WHITE_OAK.slab(), BlockusBlocks.WHITE_OAK_LOG, BlockusBlocks.STRIPPED_WHITE_OAK_LOG, true),
    CRIMSON("crimson", class_2246.field_22126, class_2246.field_22128, class_2246.field_22118, class_2246.field_22119, false),
    WARPED("warped", class_2246.field_22127, class_2246.field_22129, class_2246.field_22111, class_2246.field_22112, false),
    CHARRED("charred", BlockusBlocks.CHARRED.planks(), BlockusBlocks.CHARRED.slab(), null, null, false);

    public static final Map<String, WoodData> WOOD_DATA;
    public static final Map<String, class_2248> PLANKS_MAP;
    public static final Map<String, class_2248> SLAB_MAP;
    public static final Map<String, class_2248> LOG_MAP;
    public static final Map<String, class_2248> STRIPPED_LOG_MAP;
    public final String id;
    public final WoodData data;

    private WoodMaps(String id, class_2248 planks, class_2248 slab, class_2248 log, class_2248 strippedLog, boolean isBurnable) {
        this.id = id;
        this.data = new WoodData(planks, slab, log, strippedLog, isBurnable);
    }

    public static <T> Map<String, T> extract(Function<WoodData, T> mapper) {
        return WOOD_DATA.entrySet().stream().filter(e -> mapper.apply((WoodData)e.getValue()) != null).collect(Collectors.toMap(Map.Entry::getKey, e -> mapper.apply((WoodData)e.getValue())));
    }

    public String getId() {
        return this.id;
    }

    public WoodData data() {
        return this.data;
    }

    static {
        WOOD_DATA = Arrays.stream(WoodMaps.values()).collect(Collectors.toMap(WoodMaps::getId, WoodMaps::data));
        PLANKS_MAP = WoodMaps.extract(WoodData::planks);
        SLAB_MAP = WoodMaps.extract(WoodData::slab);
        LOG_MAP = WoodMaps.extract(WoodData::log);
        STRIPPED_LOG_MAP = WoodMaps.extract(WoodData::strippedLog);
    }

    public record WoodData(class_2248 planks, class_2248 slab, class_2248 log, class_2248 strippedLog, boolean isBurnable) {
    }
}

