/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.worldgen.foliage;

import com.brand.blockus.worldgen.foliage.BlockusFoliagePlacerType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2338;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class WhiteOakFoliagePlacer
extends class_4647 {
    public static final MapCodec<WhiteOakFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> WhiteOakFoliagePlacer.method_30411((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.method_35004((int)4, (int)16).fieldOf("height").forGetter(foliagePlacer -> foliagePlacer.height), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wide_bottom_layer_hole_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.wideBottomLayerHoleChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("corner_hole_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.cornerHoleChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.hangingLeavesChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_extension_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.hangingLeavesExtensionChance)))).apply((Applicative)instance, WhiteOakFoliagePlacer::new));
    public final class_6017 height;
    public final float wideBottomLayerHoleChance;
    public final float cornerHoleChance;
    public final float hangingLeavesChance;
    public final float hangingLeavesExtensionChance;

    public WhiteOakFoliagePlacer(class_6017 radius, class_6017 offset, class_6017 height, float wideBottomLayerHoleChance, float cornerHoleChance, float hangingLeavesChance, float hangingLeavesExtensionChance) {
        super(radius, offset);
        this.height = height;
        this.wideBottomLayerHoleChance = wideBottomLayerHoleChance;
        this.cornerHoleChance = cornerHoleChance;
        this.hangingLeavesChance = hangingLeavesChance;
        this.hangingLeavesExtensionChance = hangingLeavesExtensionChance;
    }

    protected class_4648<?> method_28843() {
        return BlockusFoliagePlacerType.WHITE_OAK_FOLIAGE_PLACER;
    }

    protected void method_23448(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, int trunkHeight, class_4647.class_5208 treeNode, int foliageHeight, int radius, int offset) {
        boolean bl = treeNode.method_27390();
        class_2338 blockPos = treeNode.method_27388().method_10086(offset - 3);
        int i = radius + treeNode.method_27389() - 1;
        this.method_23449(world, placer, random, config, blockPos, i - 1, foliageHeight - 3, bl);
        this.method_23449(world, placer, random, config, blockPos, i - 1, foliageHeight - 4, bl);
        for (int j = foliageHeight - 5; j >= 0; --j) {
            this.method_23449(world, placer, random, config, blockPos, i, j, bl);
        }
        this.method_49247(world, placer, random, config, blockPos, i, -1, bl, this.hangingLeavesChance, this.hangingLeavesExtensionChance);
    }

    public int method_26989(class_5819 random, int trunkHeight, class_4643 config) {
        return this.height.method_35008(random);
    }

    public boolean method_23451(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        boolean bl2;
        if (y == -1 && (dx == radius || dz == radius) && random.method_43057() < this.wideBottomLayerHoleChance) {
            return true;
        }
        if (y == 3) {
            return (dx > 1 || dz > 1) && dx != 0 && dz != 0;
        }
        boolean bl = dx == radius && dz == radius;
        boolean bl3 = bl2 = radius > 2;
        if (bl2) {
            return bl || dx + dz > radius * 2 - 2 && random.method_43057() < this.cornerHoleChance;
        }
        return bl && random.method_43057() < this.cornerHoleChance;
    }
}

