/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlabDumpHandler {
    private static final Logger log = LoggerFactory.getLogger(SlabDumpHandler.class);

    public static void onServerStarted(ServerStartedEvent event) {
        if (KleeSlabsConfig.getActive().dumpSlabs) {
            SlabDumpHandler.dumpSlabs();
        }
    }

    public static void dumpSlabs() {
        String slabsOutput;
        Map<String, List<class_2960>> slabsByMod = class_7923.field_41175.method_10235().stream().filter(itemName -> itemName.method_12832().endsWith("_slab")).collect(Collectors.groupingBy(class_2960::method_12836));
        Map<String, List<class_2960>> verticalSlabsByMod = class_7923.field_41175.method_10235().stream().filter(itemName -> itemName.method_12832().endsWith("_slab") && itemName.method_12832().contains("vertical")).collect(Collectors.groupingBy(class_2960::method_12836));
        for (Map.Entry<String, List<class_2960>> slabs : slabsByMod.entrySet()) {
            slabsOutput = slabs.getValue().stream().map(class_2960::method_12832).map(it -> "\"" + it + "\"").sorted().collect(Collectors.joining(",\n"));
            log.info("Slabs from mod {}:\n{}", (Object)slabs.getKey(), (Object)slabsOutput);
        }
        for (Map.Entry<String, List<class_2960>> verticalSlabs : verticalSlabsByMod.entrySet()) {
            slabsOutput = verticalSlabs.getValue().stream().map(class_2960::method_12832).map(it -> "\"" + it + "\"").sorted().collect(Collectors.joining(",\n"));
            log.info("Vertical slabs from mod {}:\n{}", (Object)verticalSlabs.getKey(), (Object)slabsOutput);
        }
    }
}

