/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.tracking.block;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.ArrayList;
import net.caffeinemc.mods.lithium.common.block.BlockListeningSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.block.ListeningBlockStatePredicate;
import net.caffeinemc.mods.lithium.common.tracking.block.SectionedBlockChangeTracker;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.world.LithiumData;
import net.caffeinemc.mods.lithium.common.world.chunk.ChunkStatusTracker;
import net.minecraft.class_1937;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import net.minecraft.class_5539;

public final class ChunkSectionChangeCallback {
    private final ArrayList<SectionedBlockChangeTracker>[] trackers = new ArrayList[BlockStateFlags.NUM_LISTENING_FLAGS];
    private short listeningMask = 0;

    public static void init() {
        if (BlockListeningSection.class.isAssignableFrom(class_2826.class)) {
            ChunkStatusTracker.registerUnloadCallback((serverWorld, chunkPos) -> {
                Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)serverWorld).lithium$getData().chunkSectionChangeCallbacks();
                int x = chunkPos.field_9181;
                int z = chunkPos.field_9180;
                for (int y = Pos.SectionYCoord.getMinYSection((class_5539)serverWorld); y <= Pos.SectionYCoord.getMaxYSectionInclusive((class_5539)serverWorld); ++y) {
                    class_4076 chunkSectionPos = class_4076.method_18676((int)x, (int)y, (int)z);
                    ChunkSectionChangeCallback chunkSectionChangeCallback = (ChunkSectionChangeCallback)changeCallbacks.remove(chunkSectionPos.method_18694());
                    if (chunkSectionChangeCallback == null) continue;
                    chunkSectionChangeCallback.onChunkSectionInvalidated(chunkSectionPos);
                }
            });
        }
    }

    public static ChunkSectionChangeCallback create(long sectionPos, class_1937 world) {
        ChunkSectionChangeCallback chunkSectionChangeCallback = new ChunkSectionChangeCallback();
        Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)world).lithium$getData().chunkSectionChangeCallbacks();
        ChunkSectionChangeCallback previous = (ChunkSectionChangeCallback)changeCallbacks.put(sectionPos, (Object)chunkSectionChangeCallback);
        if (previous != null) {
            previous.onChunkSectionInvalidated(class_4076.method_18677((long)sectionPos));
        }
        return chunkSectionChangeCallback;
    }

    public short onBlockChange(int blockGroupIndex, BlockListeningSection section) {
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        this.trackers[blockGroupIndex] = null;
        if (sectionedBlockChangeTrackers != null) {
            for (int i = 0; i < sectionedBlockChangeTrackers.size(); ++i) {
                sectionedBlockChangeTrackers.get(i).setChanged(section);
            }
        }
        this.listeningMask = (short)(this.listeningMask & (short)(~(1 << blockGroupIndex)));
        return this.listeningMask;
    }

    public short addTracker(SectionedBlockChangeTracker tracker, ListeningBlockStatePredicate blockGroup) {
        int blockGroupIndex = blockGroup.getIndex();
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        if (sectionedBlockChangeTrackers == null) {
            this.trackers[blockGroupIndex] = sectionedBlockChangeTrackers = new ArrayList();
        }
        sectionedBlockChangeTrackers.add(tracker);
        this.listeningMask = (short)(this.listeningMask | (short)(1 << blockGroupIndex));
        return this.listeningMask;
    }

    public short removeTracker(SectionedBlockChangeTracker tracker, ListeningBlockStatePredicate blockGroup) {
        int blockGroupIndex = blockGroup.getIndex();
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        if (sectionedBlockChangeTrackers != null) {
            sectionedBlockChangeTrackers.remove(tracker);
            if (sectionedBlockChangeTrackers.isEmpty()) {
                this.listeningMask = (short)(this.listeningMask & (short)(~(1 << blockGroup.getIndex())));
            }
        }
        return this.listeningMask;
    }

    public void onChunkSectionInvalidated(class_4076 sectionPos) {
        for (int flagIndex = 0; flagIndex < this.trackers.length; ++flagIndex) {
            ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[flagIndex];
            this.trackers[flagIndex] = null;
            if (sectionedBlockChangeTrackers == null) continue;
            for (int i = 0; i < sectionedBlockChangeTrackers.size(); ++i) {
                sectionedBlockChangeTrackers.get(i).onChunkSectionInvalidated(sectionPos);
            }
        }
        this.listeningMask = 0;
    }
}

