/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.util;

import com.google.common.base.Predicates;
import fuzs.permanentsponges.core.CommonAbstractions;
import fuzs.permanentsponges.init.ModRegistry;
import fuzs.permanentsponges.world.level.block.SpongeMaterial;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4153;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class LiquidAbsorptionHelper {
    private static final Int2ObjectMap<List<class_2338>> SPONGE_RADIUS = new Int2ObjectOpenHashMap();

    public static List<class_2338> getSpongeRadius(int depth) {
        return (List)SPONGE_RADIUS.computeIfAbsent(depth, LiquidAbsorptionHelper::getSortedSpongeRadius);
    }

    private static List<class_2338> getSortedSpongeRadius(int depth) {
        return class_2338.method_17962((int)(-depth), (int)(-depth), (int)(-depth), (int)depth, (int)depth, (int)depth).map(class_2338::method_10062).sorted(Comparator.comparingInt(blockPos -> Math.max(Math.max(Math.abs(blockPos.method_10263()), Math.abs(blockPos.method_10264())), Math.abs(blockPos.method_10260()))).thenComparingInt(arg_0 -> ((class_2338)class_2338.field_10980).method_19455(arg_0))).toList();
    }

    public static boolean removeAllLiquid(class_3218 level, class_2338 blockPos, int spongeRadius, boolean destroySource) {
        List<class_2338> positions = LiquidAbsorptionHelper.getSpongeRadius(spongeRadius);
        class_3341 boundingBox = new class_3341(-spongeRadius, -spongeRadius, -spongeRadius, spongeRadius, spongeRadius, spongeRadius);
        level.method_14179().method_39380(boundingBox.method_29299((class_2382)blockPos));
        boolean hasDestroyedSource = false;
        for (class_2338 currentBlockPos : positions) {
            currentBlockPos = blockPos.method_10081((class_2382)currentBlockPos);
            class_2680 blockState = level.method_8320(currentBlockPos);
            class_3610 fluidState = level.method_8316(currentBlockPos);
            if (fluidState.method_15769() && !blockState.method_26215()) continue;
            if (!hasDestroyedSource && CommonAbstractions.INSTANCE.isHotFluid(fluidState.method_15772())) {
                if (destroySource) {
                    LiquidAbsorptionHelper.destroySpongeBlock(level, blockPos);
                }
                hasDestroyedSource = true;
            }
            LiquidAbsorptionHelper.removeLiquid((class_1937)level, currentBlockPos, blockState, fluidState);
        }
        return hasDestroyedSource;
    }

    private static void destroySpongeBlock(class_3218 level, class_2338 blockPos) {
        if (level.method_8320(blockPos).method_26164(ModRegistry.PERMANENT_SPONGES_BLOCK_TAG)) {
            level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
            level.method_20290(2009, blockPos, 0);
            level.method_8396(null, blockPos, class_3417.field_15102, class_3419.field_15245, 1.0f, (1.0f + level.method_8409().method_43057() * 0.2f) * 0.7f);
        }
    }

    private static void removeLiquid(class_1937 level, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
        if (!(blockState.method_26204() instanceof class_2263) || ((class_2263)blockState.method_26204()).method_9700(null, (class_1936)level, blockPos, blockState).method_7960()) {
            boolean setToAir = false;
            if (blockState.method_26204() instanceof class_2404 || blockState.method_26215()) {
                setToAir = true;
            } else if (blockState.method_27852(class_2246.field_9993) || blockState.method_27852(class_2246.field_10463) || blockState.method_27852(class_2246.field_10376) || blockState.method_27852(class_2246.field_10238)) {
                class_2586 blockEntity = blockState.method_31709() ? level.method_8321(blockPos) : null;
                class_2248.method_9610((class_2680)blockState, (class_1936)level, (class_2338)blockPos, (class_2586)blockEntity);
                setToAir = true;
            }
            if (setToAir && !blockState.method_26215()) {
                level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                if (!fluidState.method_15769() && level.method_8409().method_43048(5) == 0) {
                    LiquidAbsorptionHelper.removeLiquidEffects(level, blockPos, fluidState.method_15772());
                }
            }
        }
    }

    public static void removeLiquidEffects(class_1937 level, class_2338 blockPos, class_3611 fluid) {
        if (CommonAbstractions.INSTANCE.isHotFluid(fluid)) {
            level.method_20290(1501, blockPos, 0);
        } else {
            level.method_20290(2009, blockPos, 0);
            level.method_8396(null, blockPos, class_3417.field_15102, class_3419.field_15245, 1.0f, (1.0f + level.method_8409().method_43057() * 0.2f) * 0.7f);
        }
    }

    public static boolean tryPreventLiquidFromEntering(class_3218 serverLevel, class_2338 pos, class_3611 fluid) {
        Map.Entry<SpongeMaterial, class_2338> entry = LiquidAbsorptionHelper.keepPositionFreeFromLiquid(serverLevel, pos);
        if (entry != null) {
            if (entry.getKey().shouldDestroyTouchingHot() && CommonAbstractions.INSTANCE.isHotFluid(fluid)) {
                LiquidAbsorptionHelper.destroySpongeBlock(serverLevel, entry.getValue());
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static Map.Entry<SpongeMaterial, class_2338> keepPositionFreeFromLiquid(class_3218 serverLevel, class_2338 blockPos) {
        if (blockPos != null) {
            class_4153 poiManager = serverLevel.method_19494();
            for (SpongeMaterial spongeMaterial : SpongeMaterial.values()) {
                class_5321 resourceKey = spongeMaterial.getPoiType().method_40237();
                int distance = (int)Math.ceil((double)(spongeMaterial.getBlockDistance() + 1) * 1.42);
                Optional<class_2338> optional = poiManager.method_21647(holder -> holder.method_40225(resourceKey), (Predicate)Predicates.alwaysTrue(), blockPos, distance, class_4153.class_4155.field_18489).filter(currentBlockPos -> Math.abs((currentBlockPos = currentBlockPos.method_10059((class_2382)blockPos)).method_10263()) <= spongeMaterial.getBlockDistance() && Math.abs(currentBlockPos.method_10264()) <= spongeMaterial.getBlockDistance() && Math.abs(currentBlockPos.method_10260()) <= spongeMaterial.getBlockDistance()).min(Comparator.comparingInt(arg_0 -> ((class_2338)blockPos).method_19455(arg_0)));
                if (!optional.isPresent()) continue;
                return Map.entry(spongeMaterial, optional.get());
            }
        }
        return null;
    }
}

