/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.component.ToggleIdentifier;
import artifacts.network.NetworkHandler;
import artifacts.network.ToggleKeyPressedPacket;
import artifacts.registry.ModKeyMappings;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;

public class ToggleKeyHandlers {
    private static final Set<ToggleInputListener> INPUT_HANDLERS = new LinkedHashSet<ToggleInputListener>();

    public static void init() {
        INPUT_HANDLERS.add(new ToggleInputListener(ToggleIdentifier.CHARM_OF_SHRINKING, ModKeyMappings.TOGGLE_CHARM_OF_SHRINKING));
        INPUT_HANDLERS.add(new ToggleInputListener(ToggleIdentifier.CHARM_OF_SINKING, ModKeyMappings.TOGGLE_CHARM_OF_SINKING));
        INPUT_HANDLERS.add(new ToggleInputListener(ToggleIdentifier.NIGHT_VISION_GOGGLES, ModKeyMappings.TOGGLE_NIGHT_VISION_GOGGLES));
        INPUT_HANDLERS.add(new ToggleInputListener(ToggleIdentifier.UNIVERSAL_ATTRACTOR, ModKeyMappings.TOGGLE_UNIVERSAL_ATTRACTOR));
        INPUT_HANDLERS.add(new ToggleInputListener(ToggleIdentifier.SCARF_OF_INVISIBILITY, ModKeyMappings.TOGGLE_SCARF_OF_INVISIBILITY));
    }

    public static void onClientTick() {
        for (ToggleInputListener inputHandler : INPUT_HANDLERS) {
            inputHandler.onClientTick();
        }
    }

    public static class_304 getKeyMapping(ToggleIdentifier identifier) {
        for (ToggleInputListener inputHandler : INPUT_HANDLERS) {
            if (inputHandler.identifier != identifier) continue;
            return inputHandler.key;
        }
        throw new IllegalArgumentException();
    }

    public static void addTooltip(ToggleIdentifier identifier, boolean addWhenUnbound, Consumer<class_2561> consumer) {
        class_304 key = ToggleKeyHandlers.getKeyMapping(identifier);
        if (key != null && (!key.method_1415() || addWhenUnbound)) {
            consumer.accept((class_2561)class_2561.method_43469((String)"%s.tooltip.toggle_keymapping".formatted("artifacts"), (Object[])new Object[]{key.method_16007()}).method_27692(class_124.field_1080));
        }
    }

    private static class ToggleInputListener {
        private final class_304 key;
        private final ToggleIdentifier identifier;
        private boolean wasToggleKeyDown;

        public ToggleInputListener(ToggleIdentifier identifier, class_304 key) {
            this.key = key;
            this.identifier = identifier;
        }

        public void onClientTick() {
            boolean isToggleKeyDown = this.key.method_1434();
            if (isToggleKeyDown && !this.wasToggleKeyDown) {
                NetworkHandler.sendToServer(new ToggleKeyPressedPacket(this.identifier));
            }
            this.wasToggleKeyDown = isToggleKeyDown;
        }
    }
}

