/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9139;

public record DeathProtectionTeleport(Value<Double> teleportationChance, Value<Integer> healthRestored, Value<Integer> cooldown, Value<Boolean> consumedOnUse) implements EquipmentAbility
{
    public static final Codec<DeathProtectionTeleport> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(DeathProtectionTeleport::teleportationChance), (App)ValueTypes.NON_NEGATIVE_INT.codec().optionalFieldOf("health_restored", Value.of(10)).forGetter(DeathProtectionTeleport::healthRestored), (App)ValueTypes.cooldownField().forGetter(DeathProtectionTeleport::cooldown), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("consume", Value.of(true)).forGetter(DeathProtectionTeleport::consumedOnUse)).apply((Applicative)instance, DeathProtectionTeleport::new));
    public static final class_9139<ByteBuf, DeathProtectionTeleport> STREAM_CODEC = class_9139.method_56905(ValueTypes.FRACTION.streamCodec(), DeathProtectionTeleport::teleportationChance, ValueTypes.NON_NEGATIVE_INT.streamCodec(), DeathProtectionTeleport::healthRestored, ValueTypes.DURATION.streamCodec(), DeathProtectionTeleport::cooldown, ValueTypes.BOOLEAN.streamCodec(), DeathProtectionTeleport::consumedOnUse, DeathProtectionTeleport::new);

    public static class_1799 findTotem(class_1309 entity) {
        for (class_1268 hand : class_1268.values()) {
            class_1657 player;
            class_1799 handItem = entity.method_5998(hand);
            DeathProtectionTeleport ability2 = (DeathProtectionTeleport)handItem.method_57824(ModDataComponents.DEATH_PROTECTION_TELEPORT.get());
            if (handItem.method_57826(ModDataComponents.DISABLED_BY_TOGGLE.get()) || ability2 == null || !ability2.isNonCosmetic() || entity instanceof class_1657 && (player = (class_1657)entity).method_7357().method_7904(handItem.method_7909())) continue;
            return handItem;
        }
        return EquipmentHelper.reduceAbilities(ModDataComponents.DEATH_PROTECTION_TELEPORT.get(), entity, true, true, class_1799.field_8037, (ability, totem, result) -> result.method_7960() ? totem : result);
    }

    public static void teleport(class_1309 entity, class_3218 level) {
        double oldX = entity.method_23317();
        double oldY = entity.method_23318();
        double oldZ = entity.method_23321();
        for (int i = 0; i < 32; ++i) {
            double newX = entity.method_23317() + (entity.method_59922().method_43058() - 0.5) * 32.0;
            double newY = class_3532.method_15350((double)(entity.method_23318() + (double)entity.method_59922().method_43048(16) - 8.0), (double)level.method_31607(), (double)(level.method_31607() + level.method_32819() - 1));
            double newZ = entity.method_23321() + (entity.method_59922().method_43058() - 0.5) * 32.0;
            class_243 oldPos = entity.method_19538();
            if (oldPos.method_1028(newX, newY, newZ) < 256.0) continue;
            if (entity.method_5765()) {
                entity.method_5848();
            }
            if (!entity.method_6082(newX, newY, newZ, true)) continue;
            entity.method_37908().method_32888((class_6880)class_5712.field_39446, oldPos, class_5712.class_7397.method_43285((class_1297)entity));
            entity.method_37908().method_43128(null, oldX, oldY, oldZ, class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
            entity.method_37908().method_43128(null, newX, newY, newZ, class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
            break;
        }
    }

    @Override
    public boolean isNonCosmetic() {
        return !class_3532.method_20390((double)((Double)this.teleportationChance().get()), (double)0.0);
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        if (class_3532.method_20390((double)((Double)this.teleportationChance().get()), (double)1.0)) {
            writer.add("constant", new Object[0]);
        } else {
            writer.add("chance", Math.round((Double)this.teleportationChance().get() * 100.0));
        }
        if (!((Boolean)this.consumedOnUse().get()).booleanValue()) {
            writer.add("not_consumed", new Object[0]);
        }
    }
}

