/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_9139;

public record ToolTierUpgrade(Value<Tier> tier) implements EquipmentAbility
{
    public static final Codec<ToolTierUpgrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.TOOL_TIER.codec().fieldOf("tier").forGetter(ToolTierUpgrade::tier)).apply((Applicative)instance, ToolTierUpgrade::new));
    public static final class_9139<ByteBuf, ToolTierUpgrade> STREAM_CODEC = class_9139.method_56434(ValueTypes.TOOL_TIER.streamCodec(), ToolTierUpgrade::tier, ToolTierUpgrade::new);

    public static boolean canHarvestWithTier(class_1309 entity, class_2680 state) {
        if (state.method_26164(ModTags.MINEABLE_WITH_DIGGING_CLAWS)) {
            Tier tier = Tier.fromLevel(EquipmentHelper.maxInt(ModDataComponents.TOOL_TIER_UPGRADE.get(), entity, ability -> ((Tier)((Object)((Object)ability.tier().get()))).getLevel(), true));
            return ToolTierUpgrade.isCorrectTierForDrops(tier, state);
        }
        return false;
    }

    public static boolean isCorrectTierForDrops(Tier tier, class_2680 state) {
        if (!state.method_29291()) {
            return true;
        }
        int i = tier.getLevel();
        if (state.method_26164(class_3481.field_33717)) {
            return i >= 4;
        }
        if (state.method_26164(class_3481.field_33718)) {
            return i >= 3;
        }
        if (state.method_26164(class_3481.field_33719)) {
            return i >= 2;
        }
        return i >= 1;
    }

    @Override
    public boolean isNonCosmetic() {
        return this.tier().get() != Tier.NONE;
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        writer.addDefaultTooltipKey(ToolTierUpgrade.getTierName((Tier)((Object)this.tier.get())));
    }

    public static class_2561 getTierName(Tier tier) {
        return class_2561.method_43471((String)"%s.tooltip.tool_tier.%s".formatted("artifacts", tier.method_15434()));
    }

    public static enum Tier implements class_3542
    {
        NONE(0),
        WOOD(1),
        STONE(2),
        IRON(3),
        DIAMOND(4),
        NETHERITE(5);

        private final int level;

        private Tier(int level) {
            this.level = level;
        }

        public static Tier fromLevel(int level) {
            return switch (level) {
                case 0 -> NONE;
                case 1 -> WOOD;
                case 2 -> STONE;
                case 3 -> IRON;
                case 4 -> DIAMOND;
                default -> NETHERITE;
            };
        }

        public int getLevel() {
            return this.level;
        }

        public String method_15434() {
            return this.toString().toLowerCase();
        }
    }
}

