/*
 * Decompiled with CFR 0.152.
 */
package artifacts.config.value.type;

import artifacts.Artifacts;
import artifacts.config.screen.ConfigEntries;
import artifacts.config.value.Value;
import artifacts.util.ModCodecs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_156;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class ValueType<T, C> {
    public abstract boolean isCorrect(T var1);

    public abstract String makeError(T var1);

    public abstract String getAllowedValuesComment();

    public abstract T read(C var1);

    public abstract C write(T var1);

    public final Codec<Value<T>> codec() {
        return ModCodecs.xorAlternative(this.configCodec().flatXmap(DataResult::success, value -> {
            DataResult dataResult;
            if (value instanceof Value.ConfigValue) {
                Value.ConfigValue configValue = (Value.ConfigValue)value;
                if (Artifacts.CONFIG.items.getValues(this).containsKey(configValue.getId())) {
                    dataResult = DataResult.success((Object)configValue);
                    return dataResult;
                }
            }
            dataResult = DataResult.error(() -> "Not a valid config value: %s".formatted(value));
            return dataResult;
        }), this.constantCodec());
    }

    protected abstract Codec<T> valueCodec();

    public final Codec<Value<T>> constantCodec() {
        return this.valueCodec().comapFlatMap(value -> this.isCorrect(value) ? DataResult.success((Object)value) : DataResult.error(() -> this.makeError(value)), Function.identity()).xmap(Value.Constant::new, Supplier::get);
    }

    public final Codec<Value.ConfigValue<T>> configCodec() {
        return class_3542.method_53955(this::getConfigValues);
    }

    public final class_9139<ByteBuf, Value<T>> streamCodec() {
        return class_9135.field_48547.method_56440(value -> value instanceof Value.ConfigValue, b -> b != false ? this.configReferenceStreamCodec() : this.valueStreamCodec().method_56432(Value.Constant::new, Supplier::get));
    }

    public abstract class_9139<ByteBuf, T> valueStreamCodec();

    public final class_9139<ByteBuf, Value.ConfigValue<T>> configReferenceStreamCodec() {
        Value.ConfigValue[] values = this.getConfigValues();
        return class_9135.method_56375(i -> values[i], (ToIntFunction)class_156.method_43658(Arrays.asList(values)));
    }

    public final class_9139<ByteBuf, Value.ConfigValue<T>> directConfigStreamCodec(String id) {
        return this.valueStreamCodec().method_56432(v -> new Value.ConfigValue<Object>(this, id, v), Value.ConfigValue::get);
    }

    private Value.ConfigValue<T>[] getConfigValues() {
        List values = List.copyOf(Artifacts.CONFIG.items.getValues(this).values());
        Value.ConfigValue[] result = (Value.ConfigValue[])Array.newInstance(values.getFirst().getClass(), values.size());
        for (int i = 0; i < values.size(); ++i) {
            result[i] = values.get(i);
        }
        return result;
    }

    public abstract ConfigEntries.ConfigEntryFactory<T> getConfigEntryFactory();
}

