/*
 * Decompiled with CFR 0.152.
 */
package artifacts.equipment;

import artifacts.component.ability.EnchantmentLevelModifiers;
import artifacts.component.ability.EquipmentAbility;
import artifacts.equipment.EquipmentSlotManager;
import artifacts.registry.ModDataComponents;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_9331;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class EquipmentHelper {
    public static boolean hasComponent(class_9331<?> type, @Nullable class_1309 entity) {
        return EquipmentHelper.reduceComponents(type, entity, false, (prefix, stack, component) -> true);
    }

    public static boolean hasAbilityActive(class_9331<? extends EquipmentAbility> type, @Nullable class_1309 entity, boolean skipItemsOnCooldown) {
        return EquipmentHelper.hasAbilityActive(type, entity, skipItemsOnCooldown, ability -> true);
    }

    public static <A extends EquipmentAbility> boolean hasAbilityActive(class_9331<A> type, @Nullable class_1309 entity, boolean skipItemsOnCooldown, Predicate<A> predicate) {
        if (entity == null) {
            return false;
        }
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, false, (ability, stack, b) -> b != false || ability.isNonCosmetic() && predicate.test(ability));
    }

    public static int getEnchantmentLevelIncrease(class_5321<class_1887> enchantment, class_1309 entity) {
        return EquipmentHelper.sumInt(ModDataComponents.ENCHANTMENT_LEVEL_MODIFIERS.get(), entity, ability -> {
            int amount = 0;
            for (EnchantmentLevelModifiers.Entry entry : ability.entries()) {
                if (!entry.enchantment().equals((Object)enchantment)) continue;
                amount += ((Integer)entry.amount().get()).intValue();
            }
            return amount;
        }, true);
    }

    public static <A extends EquipmentAbility> int sumInt(class_9331<A> type, class_1309 entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, 0, (ability, stack, i) -> i + (Integer)f.apply(ability));
    }

    public static <A extends EquipmentAbility> double maxDouble(class_9331<A> type, class_1309 entity, Function<A, Double> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, 0.0, (ability, stack, d) -> Math.max(d, (Double)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> double minDouble(class_9331<A> type, class_1309 entity, double init, Function<A, Double> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, init, (ability, stack, d) -> Math.min(d, (Double)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> int maxInt(class_9331<A> type, class_1309 entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, 0, (ability, stack, d) -> Math.max(d, (Integer)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> int minInt(class_9331<A> type, class_1309 entity, int init, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, init, (ability, stack, d) -> Math.min(d, (Integer)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> void iterateAbilities(class_9331<A> type, class_1309 entity, boolean skipItemsOnCooldown, boolean skipDisabledItems, BiConsumer<A, class_1799> consumer) {
        EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, skipDisabledItems, class_3902.field_17274, (ability, stack, unit) -> {
            consumer.accept((Object)ability, (class_1799)stack);
            return class_3902.field_17274;
        });
    }

    public static <ABILITY extends EquipmentAbility, ACC> ACC reduceAbilities(class_9331<ABILITY> type, class_1309 entity, boolean skipItemsOnCooldown, boolean skipDisabledItems, ACC init, TriFunction<ABILITY, class_1799, ACC, ACC> f) {
        return (ACC)EquipmentHelper.reduceEquipment(entity, init, (stack, init_) -> {
            EquipmentAbility ability = (EquipmentAbility)stack.method_57824(type);
            if (ability != null) {
                boolean checkCosmetic;
                class_1657 player;
                boolean checkCooldown = !skipItemsOnCooldown || !(entity instanceof class_1657) || !(player = (class_1657)entity).method_7357().method_7904(stack.method_7909());
                boolean checkDisabled = !skipDisabledItems || !stack.method_57826(ModDataComponents.DISABLED_BY_TOGGLE.get());
                boolean bl = checkCosmetic = !skipDisabledItems || ability.isNonCosmetic();
                if (checkCooldown && checkDisabled && checkCosmetic) {
                    init_ = f.apply((Object)ability, stack, init_);
                }
            }
            return init_;
        });
    }

    public static <C> void iterateComponents(class_9331<C> type, class_1309 entity, Visitor<C> visitor) {
        EquipmentHelper.reduceComponents(type, entity, class_3902.field_17274, (unit, stack, component) -> {
            visitor.visit(stack, component);
            return class_3902.field_17274;
        });
    }

    public static <C, ACC> ACC reduceComponents(class_9331<C> type, class_1309 entity, ACC init, Accumulator<C, ACC> visitor) {
        return (ACC)EquipmentHelper.reduceEquipment(entity, init, (stack, acc) -> {
            Object component = stack.method_57824(type);
            if (component != null) {
                acc = visitor.accumulate((Object)acc, (class_1799)stack, (Object)component);
            }
            return acc;
        });
    }

    public static void iterateEquipment(class_1309 entity, Consumer<class_1799> consumer) {
        EquipmentHelper.reduceEquipment(entity, class_3902.field_17274, (stack, unit) -> {
            consumer.accept((class_1799)stack);
            return unit;
        });
    }

    public static <ACC> ACC reduceEquipment(class_1309 entity, ACC init, BiFunction<class_1799, ACC, ACC> f) {
        return EquipmentSlotManager.reduceEquipment(entity, init, f);
    }

    @FunctionalInterface
    public static interface Accumulator<E, ACC> {
        public ACC accumulate(ACC var1, class_1799 var2, E var3);
    }

    @FunctionalInterface
    public static interface Visitor<E> {
        public void visit(class_1799 var1, E var2);
    }
}

