/*
 * Decompiled with CFR 0.152.
 */
package artifacts.fabric.network;

import artifacts.network.NetworkHandler;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_8710;

public class FabricNetworkHandler {
    public static void registerClientboundPayloads() {
        for (NetworkHandler.PayloadHandler<?> payloadHandler : NetworkHandler.CLIENTBOUND_HANDLERS) {
            FabricNetworkHandler.registerClientboundPayload(payloadHandler);
        }
    }

    public static void registerServerboundPayloads() {
        for (NetworkHandler.PayloadHandler<?> payloadHandler : NetworkHandler.SERVERBOUND_HANDLERS) {
            FabricNetworkHandler.registerServerboundPayload(payloadHandler);
        }
    }

    public static void registerServerboundReceivers() {
        for (NetworkHandler.PayloadHandler<?> payloadHandler : NetworkHandler.SERVERBOUND_HANDLERS) {
            FabricNetworkHandler.registerServerboundReceiver(payloadHandler);
        }
    }

    private static <T extends class_8710> void registerClientboundPayload(NetworkHandler.PayloadHandler<T> payloadHandler) {
        PayloadTypeRegistry.playS2C().register(payloadHandler.type(), payloadHandler.codec());
    }

    private static <T extends class_8710> void registerServerboundPayload(NetworkHandler.PayloadHandler<T> payloadHandler) {
        PayloadTypeRegistry.playC2S().register(payloadHandler.type(), payloadHandler.codec());
    }

    private static <T extends class_8710> void registerServerboundReceiver(NetworkHandler.PayloadHandler<T> payloadHandler) {
        ServerPlayNetworking.registerGlobalReceiver(payloadHandler.type(), (payload, context) -> payloadHandler.receiver().receive(payload, new FabricServerboundPayloadContext((class_1657)context.player(), context)));
    }

    private record FabricServerboundPayloadContext(class_1657 player, ServerPlayNetworking.Context context) implements NetworkHandler.PayloadContext
    {
        @Override
        public void queue(Runnable runnable) {
            this.context.server().execute(runnable);
        }
    }
}

