/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item;

import artifacts.Artifacts;
import artifacts.client.ToggleKeyHandlers;
import artifacts.component.ToggleIdentifier;
import artifacts.component.ability.EquipmentAbility;
import artifacts.item.WearableArtifactItem;
import artifacts.registry.ModDataComponents;
import artifacts.util.TooltipHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Inject(method={"getTooltipLines"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")})
    private void getTooltipLines(class_1792.class_9635 context, @Nullable class_1657 player, class_1836 tooltipFlag, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> tooltip) {
        class_9290 lore;
        if (!Artifacts.CONFIG.client.showTooltips.get().booleanValue()) {
            return;
        }
        class_1799 stack = (class_1799)this;
        if (stack.method_7909() instanceof WearableArtifactItem && TooltipHelper.isCosmetic(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"%s.tooltip.cosmetic".formatted("artifacts")).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
        }
        if ((lore = (class_9290)stack.method_57824(ModDataComponents.ABILITY_LORE.get())) != null) {
            lore.method_57409(context, tooltip::add, tooltipFlag);
        }
        for (Supplier<? extends class_9331<? extends EquipmentAbility>> type : ModDataComponents.TOOLTIP_ORDER) {
            EquipmentAbility provider = (EquipmentAbility)stack.method_57824(type.get());
            if (provider == null || !provider.isNonCosmetic()) continue;
            provider.addToTooltip(new EquipmentAbility.TooltipWriter(type.get(), tooltip::add, context, stack));
        }
        ToggleIdentifier toggleKey = (ToggleIdentifier)((Object)stack.method_57824(ModDataComponents.TOGGLE_KEY.get()));
        if (toggleKey != null && !TooltipHelper.isCosmetic(stack) && player != null && !player.method_37908().method_8608()) {
            ToggleKeyHandlers.addTooltip(toggleKey, stack.method_57826(ModDataComponents.DISABLED_BY_TOGGLE.get()), tooltip::add);
        }
    }

    @Inject(method={"getTooltipLines"}, require=0, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/item/ItemStack;addAttributeTooltips(Ljava/util/function/Consumer;Lnet/minecraft/world/entity/player/Player;)V")})
    private void addAttributeTooltips(class_1792.class_9635 context, class_1657 player, class_1836 tooltipFlag, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> tooltip) {
        TooltipHelper.addAttributeTooltips(tooltip::add, (class_1799)this, context);
    }
}

