/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.epicpowerbracelets;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.foxgirl.epicpowerbracelets.item.AbstractBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.InvisibilityBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.NightVisionBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.SlowFallBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.SpeedBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.StrengthBraceletItem;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public final class EpicPowerBraceletsImpl {
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"epicpowerbracelets", (class_5321)class_7924.field_41197);
    public static final RegistrySupplier<AbstractBraceletItem> INVISIBILITY_BRACELET = ITEMS.register("invisibility_bracelet", InvisibilityBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> NIGHT_VISION_BRACELET = ITEMS.register("night_vision_bracelet", NightVisionBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> SLOW_FALL_BRACELET = ITEMS.register("slow_fall_bracelet", SlowFallBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> SPEED_BRACELET = ITEMS.register("speed_bracelet", SpeedBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> STRENGTH_BRACELET = ITEMS.register("strength_bracelet", StrengthBraceletItem::new);
    public static final Supplier<Set<AbstractBraceletItem>> BRACELETS = Suppliers.memoize(() -> ImmutableSet.copyOf((Object[])new AbstractBraceletItem[]{(AbstractBraceletItem)((Object)((Object)INVISIBILITY_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)NIGHT_VISION_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)SLOW_FALL_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)SPEED_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)STRENGTH_BRACELET.get()))}));
    private final Map<UUID, Set<class_1291>> activeEffectsMapping = new WeakHashMap<UUID, Set<class_1291>>();

    public EpicPowerBraceletsImpl() {
        ITEMS.register();
        TickEvent.PLAYER_POST.register(this::onPlayerTick);
        TickEvent.SERVER_LEVEL_POST.register(this::onLevelTick);
    }

    private Set<class_1291> getActiveEffects(class_1657 player) {
        return this.activeEffectsMapping.computeIfAbsent(player.method_5667(), __ -> new ReferenceArraySet());
    }

    private void onPlayerTick(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return;
        }
        Set<class_1291> activeEffects = this.getActiveEffects(player);
        for (AbstractBraceletItem bracelet : BRACELETS.get()) {
            class_6880<class_1291> effect = bracelet.getMobEffect();
            class_1293 effectInstance = player.method_6112(effect);
            if (player.method_6047().method_7909() == bracelet || player.method_6079().method_7909() == bracelet) {
                if (effectInstance != null && effectInstance.method_5578() != 0) continue;
                player.method_37222(new class_1293(effect, 210), (class_1297)player);
                activeEffects.add((class_1291)effect.comp_349());
                continue;
            }
            if (!activeEffects.remove(effect.comp_349()) || effectInstance == null || effectInstance.method_5584() > 210 || effectInstance.method_5578() != 0) continue;
            player.method_6016(effect);
        }
    }

    private void applyBraceletToMob(class_1308 mob, AbstractBraceletItem bracelet) {
        class_6880<class_1291> effect = bracelet.getMobEffect();
        class_1293 effectInstance = mob.method_6112(effect);
        if (effectInstance == null || effectInstance.method_5578() == 0) {
            mob.method_37222(new class_1293(effect, 70), (class_1297)mob);
        }
    }

    private void onLevelTick(class_3218 level) {
        for (class_1297 entity : level.method_27909()) {
            if (!(entity instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            for (class_1799 stack : mob.method_5877()) {
                class_1792 item = stack.method_7909();
                if (!(item instanceof AbstractBraceletItem)) continue;
                this.applyBraceletToMob(mob, (AbstractBraceletItem)item);
            }
        }
    }
}

