/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.model.ModelPartGetter;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.function.Consumer;
import net.minecraft.class_1422;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_7988;
import net.minecraft.class_922;
import net.minecraft.class_927;

public abstract class ThievesFishRenderer<V extends AbstractFishVariant, T extends class_1422 & class_7988<class_6880<V>>, M extends class_583<T> & HeadphoneModel.Scaleable<T>>
extends class_927<T, M> {
    protected ThievesFishRenderer(class_5617.class_5618 context, M entityModel) {
        super(context, entityModel, 0.15f);
        this.method_4046(new GlowFishLayer(this));
        this.method_4046(new HeadphoneLayer((class_922<?, ?>)this, context.method_32170(), (HeadphoneModel.Scaleable)entityModel));
    }

    public void render(T livingEntity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        this.field_4673 = ((ThievesFish)livingEntity).isTrophy() ? 0.25f : 0.15f;
        super.method_4054(livingEntity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, class_4587 poseStack, float bob, float rotationYaw, float partialTicks, float scale) {
        super.method_4058(entity, poseStack, bob, rotationYaw, partialTicks, scale);
        boolean inWater = entity.method_5799() || ((ThievesFish)entity).isNoFlip();
        RotationRenderData rotationRenderData = this.setupRotations(entity, inWater);
        float degree = rotationRenderData.baseDegree * class_3532.method_15374((float)(rotationRenderData.bodyRotBase * rotationRenderData.bodyRotSpeed * bob));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(degree));
        if (!inWater) {
            rotationRenderData.translateConsumer.accept(poseStack);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        }
        this.doFishPitchYaw(entity, partialTicks);
    }

    public class_2960 getTextureLocation(T livingEntity) {
        return ((AbstractFishVariant)((class_6880)((class_7988)livingEntity).method_47827()).comp_349()).fullTexture();
    }

    protected void scale(T livingEntity, class_4587 poseStack, float partialTickTime) {
        float scale = ((ThievesFish)livingEntity).isTrophy() ? 1.0f : 0.5f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void doFishPitchYaw(T entity, float partialTicks) {
        float headPitch = class_3532.method_16439((float)partialTicks, (float)((class_1422)entity).field_6004, (float)entity.method_36455());
        if (!((class_1422)entity).field_6007) {
            ((ModelPartGetter)this.method_4038()).main().field_3654 = headPitch * ((float)Math.PI / 180);
        }
    }

    public abstract RotationRenderData setupRotations(T var1, boolean var2);

    public record RotationRenderData(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<class_4587> translateConsumer) {
        public static RotationRenderData create(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<class_4587> translateConsumer) {
            return new RotationRenderData(bodyRotBase, bodyRotSpeed, baseDegree, translateConsumer);
        }
    }
}

