/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.google.common.collect.ImmutableList;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractSchoolingThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.debug.SchoolingFishDebug;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1425;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchoolingThievesFish<T extends AbstractFishVariant>
extends AbstractFlockFish
implements ThievesFish<T> {
    private static final class_2940<Boolean> TROPHY = class_2945.method_12791(AbstractSchoolingThievesFish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_FED = class_2945.method_12791(AbstractSchoolingThievesFish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> NO_FLIP = class_2945.method_12791(AbstractSchoolingThievesFish.class, (class_2941)class_2943.field_13323);
    protected static final ImmutableList<class_4149<? extends class_4148<? super AbstractFlockFish>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, FOTSensorTypes.NEAREST_SCHOOLING_THIEVES_FISH, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.NEAREST_FLOCK_LEADER, (Object)class_4149.field_18469);
    protected static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18445, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_22474, (Object)class_4140.field_18444, (Object)class_4140.field_22357, FOTMemoryModuleTypes.SCHOOL_SIZE, FOTMemoryModuleTypes.FLOCK_LEADER, FOTMemoryModuleTypes.IS_FLOCK_LEADER, (Object[])new class_4140[]{FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER, FOTMemoryModuleTypes.FLOCK_FOLLOWERS, FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER, class_4140.field_28326, class_4140.field_28327, class_4140.field_28325, class_4140.field_18448, class_4140.field_39408, class_4140.field_30244, FOTMemoryModuleTypes.BREACHED_TICK});
    private final class_5321<? extends class_2378<T>> registryKey;
    private final class_5321<T> resourceKey;

    public AbstractSchoolingThievesFish(class_1299<? extends class_1425> entityType, class_1937 level, class_5321<? extends class_2378<T>> registryKey, class_5321<T> resourceKey) {
        super(entityType, level);
        this.method_18382();
        this.registryKey = registryKey;
        this.resourceKey = resourceKey;
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
        this.field_6206 = new class_1332((class_1308)this, 10);
    }

    @Override
    public class_5321<? extends class_2378<T>> getRegistryKey() {
        return this.registryKey;
    }

    @Override
    public class_5321<T> getDefaultKey() {
        return this.resourceKey;
    }

    public void method_5773() {
        super.method_5773();
        SchoolingFishDebug.tick(this);
        if (this.method_6470() && this.hasLeader() && !this.getLeader().method_5805()) {
            AbstractSchoolingThievesFishAi.resetMemories(this);
        }
    }

    protected void method_5959() {
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (!this.method_37908().method_8608() && this.method_29504() && this.method_6470()) {
            this.getLeader().removeFollower();
        }
        super.method_5650(reason);
    }

    @Override
    public boolean method_6470() {
        return this.method_18868().method_18896(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER) && (Boolean)this.method_18868().method_18904(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER).get() != false;
    }

    public void method_6466() {
        this.getLeader().removeFollower();
        this.method_18868().method_18875(FOTMemoryModuleTypes.FLOCK_LEADER);
    }

    @Override
    public boolean method_6469() {
        return this.isLeader() && this.getSchoolSize() < this.method_6465();
    }

    public boolean method_6467() {
        return this.method_18868().method_18896(FOTMemoryModuleTypes.FLOCK_FOLLOWERS) && !this.getFlockFollowers().isEmpty() && this.getSchoolSize() > 1;
    }

    @Override
    public boolean isLeader() {
        return this.method_18868().method_18896(FOTMemoryModuleTypes.IS_FLOCK_LEADER) && (Boolean)this.method_18868().method_18904(FOTMemoryModuleTypes.IS_FLOCK_LEADER).get() != false;
    }

    public List<AbstractFlockFish> getFlockFollowers() {
        return (List)this.method_18868().method_18904(FOTMemoryModuleTypes.FLOCK_FOLLOWERS).get();
    }

    @Override
    public void startFollowingThievesFish(AbstractFlockFish leader) {
        this.method_18868().method_18878(FOTMemoryModuleTypes.FLOCK_LEADER, (Object)leader);
        this.method_18868().method_18878(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER, (Object)true);
        leader.method_18868().method_18878(FOTMemoryModuleTypes.IS_FLOCK_LEADER, (Object)true);
        leader.addFollower();
    }

    @Override
    public void addThievesFishFollowers(Stream<AbstractFlockFish> followers) {
        List<AbstractFlockFish> list = followers.limit(this.method_6465() - this.getSchoolSize()).filter(fish -> fish != this).collect(Collectors.toList());
        boolean hasFlockFollowerMem = this.method_18868().method_18896(FOTMemoryModuleTypes.FLOCK_FOLLOWERS);
        list.forEach(fish -> {
            fish.startFollowingThievesFish(this);
            if (hasFlockFollowerMem) {
                this.getFlockFollowers().add((AbstractFlockFish)((Object)fish));
            }
        });
        if (!list.isEmpty() && !hasFlockFollowerMem) {
            this.method_18868().method_18878(FOTMemoryModuleTypes.FLOCK_FOLLOWERS, list);
        }
    }

    @Override
    public boolean hasFollowCooldown() {
        return this.method_18868().method_18896(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS);
    }

    @Override
    public boolean isSameType(AbstractFlockFish other) {
        return this.method_5864() == other.method_5864();
    }

    @Override
    public boolean hasLeader() {
        return this.method_18868().method_18896(FOTMemoryModuleTypes.FLOCK_LEADER);
    }

    @Override
    public AbstractFlockFish getLeader() {
        return (AbstractFlockFish)((Object)this.method_18868().method_18904(FOTMemoryModuleTypes.FLOCK_LEADER).get());
    }

    @Override
    public void addFollower() {
        this.method_18868().method_18878(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)(this.getSchoolSize() + 1));
    }

    @Override
    public void removeFollower() {
        this.removeFollower(true);
    }

    public void removeFollower(boolean eraseIsLeader) {
        this.method_18868().method_18878(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)(this.getSchoolSize() - 1));
        if (eraseIsLeader && this.getSchoolSize() == 1) {
            this.method_18868().method_18875(FOTMemoryModuleTypes.IS_FLOCK_LEADER);
        }
    }

    @Override
    public int getSchoolSize() {
        return this.method_18868().method_18896(FOTMemoryModuleTypes.SCHOOL_SIZE) ? (Integer)this.method_18868().method_18904(FOTMemoryModuleTypes.SCHOOL_SIZE).get() : 1;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TROPHY, (Object)false);
        builder.method_56912(HAS_FED, (Object)false);
        builder.method_56912(NO_FLIP, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("variant", ((class_6880)this.method_47827()).method_40230().orElse(this.getDefaultKey()).method_29177().toString());
        compound.method_10556("Trophy", this.isTrophy());
        compound.method_10556("HasFed", this.hasFed());
        compound.method_10556("NoFlip", this.isNoFlip());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        Optional.ofNullable(class_2960.method_12829((String)compound.method_10558("variant"))).map(resourceLocation -> class_5321.method_29179(this.getRegistryKey(), (class_2960)resourceLocation)).flatMap(resourceKey -> this.method_56673().method_30530(this.getRegistryKey()).method_40264(resourceKey)).ifPresent(arg_0 -> ((AbstractSchoolingThievesFish)this).method_47826(arg_0));
        this.setTrophy(compound.method_10577("Trophy"));
        this.setHasFed(compound.method_10577("HasFed"));
        this.setNoFlip(compound.method_10577("NoFlip"));
        AbstractSchoolingThievesFishAi.resetMemories(this);
    }

    public void method_6455(class_1799 itemStack) {
        super.method_6455(itemStack);
        this.saveToBucket(itemStack);
    }

    public void method_35170(class_2487 compound) {
        super.method_35170(compound);
        this.loadFromBucket(compound, this.method_56673());
        if (!compound.method_10545("variant")) {
            class_2378 registry = this.method_56673().method_30530(this.registryKey);
            Optional muha = class_156.method_40083(registry.method_40270().toList(), (class_5819)this.method_59922());
            this.method_47826((class_6880)muha.orElseGet(() -> registry.method_40290(this.resourceKey)));
            this.setTrophy(this.field_5974.method_43056());
        }
    }

    public float method_6144(class_2338 blockPos, class_4538 level) {
        if (AbstractThievesFishAi.isPosNearNearestRepellent(this, blockPos)) {
            return -1.0f;
        }
        return super.method_6144(blockPos, level);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isFood(itemStack) && !this.isTrophy() && !this.hasFed()) {
            if (!this.method_37908().method_8608()) {
                this.growUp(player, itemStack);
            }
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean hurt = super.method_5643(source, amount);
        if (this.method_37908().method_8608()) {
            return false;
        }
        if (hurt && source.method_5529() instanceof class_1309) {
            AbstractSchoolingThievesFishAi.wasHurtBy(this);
        }
        return hurt;
    }

    @Nullable
    public class_1315 method_5943(class_5425 accessor, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        if (spawnType == class_3730.field_16473) {
            return spawnGroupData;
        }
        spawnGroupData = super.method_5943(accessor, difficulty, spawnType, spawnGroupData);
        return this.defaultFinalizeSpawn(accessor, (class_1309)this, spawnType, spawnGroupData);
    }

    public void method_5674(class_2940<?> key) {
        if (TROPHY.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    protected void method_5958() {
        super.method_5958();
        this.setNoFlip(!this.field_6007 && this.isFishBreached(this.method_18868()));
    }

    @Override
    public boolean isTrophy() {
        return (Boolean)this.field_6011.method_12789(TROPHY);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.method_5996(class_5134.field_23716).method_6192((double)FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.field_6011.method_12778(TROPHY, (Object)trophy);
    }

    @Override
    public boolean hasFed() {
        return (Boolean)this.field_6011.method_12789(HAS_FED);
    }

    @Override
    public void setHasFed(boolean hasFed) {
        this.field_6011.method_12778(HAS_FED, (Object)hasFed);
    }

    @Override
    public void setNoFlip(boolean noFlip) {
        this.field_6011.method_12778(NO_FLIP, (Object)noFlip);
    }

    @Override
    public boolean isNoFlip() {
        return (Boolean)this.field_6011.method_12789(NO_FLIP);
    }

    private void growUp(class_1657 player, class_1799 itemStack) {
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        if (this.field_5974.method_43048(10) == 0) {
            this.setTrophy(true);
            this.setHasFed(true);
            this.method_6033(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
    }
}

