/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7891;

public interface AbstractFishVariant {
    public int customModelData();

    public String name();

    public class_2960 texture();

    public class_2960 fullTexture();

    public Optional<class_2960> fullGlowTexture();

    public Optional<class_2960> glowTexture();

    public SpawnSettings spawnSettings();

    public static <T extends AbstractFishVariant> Codec<T> simpleCodec(Function5<String, class_2960, Optional<class_2960>, SpawnSettings, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.fieldOf("name").forGetter(AbstractFishVariant::name), (App)class_2960.field_25139.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)class_2960.field_25139.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)SpawnSettings.CODEC.optionalFieldOf("spawn_settings", (Object)new SpawnSettings(List.of(), Optional.empty())).forGetter(AbstractFishVariant::spawnSettings), (App)class_5699.field_33441.fieldOf("custom_model_data").forGetter(AbstractFishVariant::customModelData)).apply((Applicative)instance, factory));
    }

    public static <T extends AbstractFishVariant> Codec<T> networkCodec(Function4<String, class_2960, Optional<class_2960>, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.fieldOf("name").forGetter(AbstractFishVariant::name), (App)class_2960.field_25139.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)class_2960.field_25139.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)class_5699.field_33441.fieldOf("custom_model_data").forGetter(AbstractFishVariant::customModelData)).apply((Applicative)instance, factory));
    }

    public static class_2960 fullTextureId(class_2960 texture) {
        return texture.method_45134(string -> "textures/" + string + ".png");
    }

    public static <T extends AbstractFishVariant> class_6880<T> getSpawnVariant(class_3218 serverLevel, class_5455 registryAccess, class_5321<? extends class_2378<? extends T>> registryKey, class_5321<T> defaultKey, class_1309 livingEntity, boolean fromBucket) {
        class_2378 registry = registryAccess.method_30530(registryKey);
        SpawnConditionContext context = new SpawnConditionContext(serverLevel, registryAccess, livingEntity.method_24515(), livingEntity.method_59922());
        Optional muha = class_156.method_40083(registry.method_40270().filter(variant -> fromBucket || class_156.method_56613(((AbstractFishVariant)variant.comp_349()).spawnSettings().entity()).test(context)).toList(), (class_5819)livingEntity.method_59922());
        return (class_6880)muha.orElseGet(() -> registry.method_40290(defaultKey));
    }

    public record SpawnSettings(List<SpawnCondition> entity, Optional<List<SpawnCondition>> fishing) {
        public static final Codec<SpawnSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FOTSpawnConditions.DIRECT_CODEC.listOf().optionalFieldOf("entity", List.of()).forGetter(SpawnSettings::entity), (App)FOTSpawnConditions.DIRECT_CODEC.listOf().optionalFieldOf("fishing").forGetter(SpawnSettings::fishing)).apply((Applicative)instance, SpawnSettings::new));
        public static final SpawnSettings EMPTY = new SpawnSettings(List.of(), Optional.empty());
    }

    public record RegisterContext<T>(String entityName, Function5<String, class_2960, Optional<class_2960>, SpawnSettings, Integer, T> factory) {
        public static <T> RegisterContext<T> create(String entityName, Function5<String, class_2960, Optional<class_2960>, SpawnSettings, Integer, T> factory) {
            return new RegisterContext<T>(entityName, factory);
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, SpawnCondition ... conditions) {
            this.register(context, key, name, customModelData, false, List.of(conditions), List.of());
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, List<SpawnCondition> conditions, List<SpawnCondition> fishingOverride) {
            this.register(context, key, name, customModelData, false, conditions, fishingOverride);
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow, SpawnCondition ... conditions) {
            this.register(context, key, name, customModelData, glow, List.of(conditions), List.of());
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow, List<SpawnCondition> conditions, List<SpawnCondition> fishingOverride) {
            class_2960 texture = FishOfThieves.id("entity/" + this.entityName + "/" + name);
            class_2960 glowTexture = FishOfThieves.id("entity/" + this.entityName + "/" + name + "_glow");
            context.method_46838(key, this.factory.apply((Object)name, (Object)texture, glow ? Optional.of(glowTexture) : Optional.empty(), (Object)new SpawnSettings(conditions, fishingOverride.isEmpty() ? Optional.empty() : Optional.of(fishingOverride)), (Object)customModelData));
        }
    }
}

