/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.annotations;

import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigInfo;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ConfigInfo {
    public String icon() default "box";

    @Nls(capitalization=Nls.Capitalization.Title)
    public String title() default "";

    public String titleTranslation() default "";

    public String description() default "";

    public String descriptionTranslation() default "";

    public Link[] links() default {};

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Provider {
        public Class<? extends ResourcefulConfigInfo> value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Gradient {
        @Pattern(value="\\d+deg")
        public String value();

        @Pattern(value="^#(?:[0-9a-fA-F]{3}){1,2}$")
        public String first();

        @Pattern(value="^#(?:[0-9a-fA-F]{3}){1,2}$")
        public String second();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Color {
        @Pattern(value="^#(?:[0-9a-fA-F]{3}){1,2}$")
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Link {
        @Pattern(value="https?://(www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_+.~#?&/=]*)")
        public String value();

        public String icon();

        @Nls(capitalization=Nls.Capitalization.Title)
        public String text();

        public String textTranslation() default "";
    }
}

