/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable.DraggableItem;
import com.teamresourceful.resourcefulconfig.client.utils.KeyCodeHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Vector2d;

public class DraggableList<T>
extends ListWidget {
    private final Vector2d draggingOffset = new Vector2d();
    private int draggingIndex = -1;
    private Consumer<List<T>> onUpdate = value -> {};
    private boolean canDelete = true;

    public DraggableList(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setOnUpdate(Consumer<List<T>> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public void addAll(List<T> values) {
        this.items.clear();
        for (T value : values) {
            AtomicReference<DraggableItem<T>> item = new AtomicReference<DraggableItem<T>>();
            item.set(new DraggableItem<T>(this.field_22758, this, value, () -> {
                this.items.remove(item.get());
                this.onUpdate.accept(this.items.stream().map(i -> (DraggableItem)i).map(DraggableItem::value).toList());
                this.updateScrollBar();
            }));
            this.items.add((ListWidget.Item)item.get());
        }
        this.updateLastHeight();
    }

    @Override
    @Deprecated
    public void add(ListWidget.Item item) {
        throw new UnsupportedOperationException("Use addAll(T value) instead.");
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        if (!this.method_25405(mouseX, mouseY) && this.draggingIndex != -1 && !KeyCodeHelper.isMouseKeyPressed(0)) {
            this.draggingIndex = -1;
        }
        graphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        this.renderPossiblePositionLine(graphics, mouseX, mouseY);
        graphics.method_44380();
        this.renderDraggedItem(graphics, mouseX, mouseY);
    }

    private void renderPossiblePositionLine(class_332 graphics, int mouseX, int mouseY) {
        if (this.draggingIndex == -1) {
            return;
        }
        int hoveredIndex = this.getItemOver(mouseX, mouseY);
        if (hoveredIndex != this.draggingIndex && hoveredIndex != -1) {
            ListWidget.Item hoveredItem = (ListWidget.Item)this.items.get(hoveredIndex);
            boolean isAbove = hoveredIndex < this.draggingIndex;
            int y = hoveredItem.method_46427() + (isAbove ? -1 : hoveredItem.method_25364() - 1);
            graphics.method_25294(hoveredItem.method_46426(), y, hoveredItem.method_46426() + hoveredItem.method_25368(), y + 2, -11141291);
        }
    }

    private void renderDraggedItem(class_332 graphics, int mouseX, int mouseY) {
        if (this.draggingIndex == -1) {
            return;
        }
        ListWidget.Item item = (ListWidget.Item)this.items.get(this.draggingIndex);
        if (!(item instanceof DraggableItem)) {
            return;
        }
        DraggableItem draggableItem = (DraggableItem)item;
        class_4587 stack = graphics.method_51448();
        stack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        stack.method_46416(0.0f, 0.0f, 300.0f);
        int x = (int)((double)mouseX - this.draggingOffset.x);
        int y = (int)((double)mouseY - this.draggingOffset.y);
        draggableItem.render(graphics, x, y, mouseX, mouseY, true, false, false);
        RenderSystem.disableBlend();
        stack.method_22909();
    }

    public int getItemOver(double mouseX, double mouseY) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ListWidget.Item)this.items.get(i)).method_25405(mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            this.draggingIndex = this.getItemOver(mouseX, mouseY);
            if (this.draggingIndex != -1) {
                ListWidget.Item item = (ListWidget.Item)this.items.get(this.draggingIndex);
                this.draggingOffset.set(mouseX - (double)item.method_46426(), mouseY - (double)item.method_46427());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingIndex != -1) {
            int newIndex = this.getItemOver(mouseX, mouseY);
            if (newIndex != -1 && newIndex != this.draggingIndex) {
                this.items.add(newIndex, (ListWidget.Item)this.items.remove(this.draggingIndex));
                this.onUpdate.accept(this.items.stream().map(item -> (DraggableItem)item).map(DraggableItem::value).toList());
            }
            this.draggingIndex = -1;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean isDraggingItem() {
        return this.draggingIndex != -1;
    }

    public ListWidget.Item getDraggingItem() {
        return this.draggingIndex != -1 ? (ListWidget.Item)this.items.get(this.draggingIndex) : null;
    }
}

