/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.animation;

import fuzs.mutantmonsters.client.animation.Transform;
import fuzs.mutantmonsters.world.entity.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_3532;
import net.minecraft.class_630;

public class Animator {
    private int tempTick;
    private int prevTempTick;
    private boolean correctAnim;
    private AnimatedEntity animEntity;
    private final Map<class_630, Transform> transformMap = new HashMap<class_630, Transform>();
    private final Map<class_630, Transform> prevTransformMap = new HashMap<class_630, Transform>();
    private float partialTick;

    public AnimatedEntity getEntity() {
        return this.animEntity;
    }

    public void update(AnimatedEntity entity, float partialTick) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = false;
        this.animEntity = entity;
        this.transformMap.clear();
        this.prevTransformMap.clear();
        this.partialTick = partialTick;
    }

    public boolean setAnimation(EntityAnimation animation) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = this.animEntity.getAnimation() == animation;
        return this.correctAnim;
    }

    public void startPhase(int duration) {
        if (this.correctAnim) {
            this.prevTempTick = this.tempTick;
            this.tempTick += duration;
        }
    }

    public void setStationaryPhase(int duration) {
        this.startPhase(duration);
        this.endPhase(true);
    }

    public void resetPhase(int duration) {
        this.startPhase(duration);
        this.endPhase();
    }

    public void rotate(class_630 box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).getRotation().add(x, y, z);
        }
    }

    public void move(class_630 box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).getOffset().add(x, y, z);
        }
    }

    private Transform getTransform(class_630 box) {
        return this.transformMap.computeIfAbsent(box, b -> new Transform());
    }

    public void endPhase() {
        this.endPhase(false);
    }

    private void endPhase(boolean stationary) {
        if (this.correctAnim) {
            int animTick = this.animEntity.getAnimationTick();
            if (animTick >= this.prevTempTick && animTick < this.tempTick) {
                if (stationary) {
                    for (class_630 model : this.prevTransformMap.keySet()) {
                        Transform transform = this.prevTransformMap.get(model);
                        transform.rotate(model, 1.0f);
                        transform.offset(model, 1.0f);
                    }
                } else {
                    Transform transform;
                    class_630 model;
                    class_630 modelPart;
                    float tick = ((float)(animTick - this.prevTempTick) + this.partialTick) / (float)(this.tempTick - this.prevTempTick);
                    float inc = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
                    float dec = 1.0f - inc;
                    Iterator<class_630> iterator = this.prevTransformMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        model = modelPart = iterator.next();
                        transform = this.prevTransformMap.get(model);
                        transform.rotate(model, dec);
                        transform.offset(model, dec);
                    }
                    iterator = this.transformMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        model = modelPart = iterator.next();
                        transform = this.transformMap.get(model);
                        transform.rotate(model, inc);
                        transform.offset(model, inc);
                    }
                }
            }
            if (!stationary) {
                this.prevTransformMap.clear();
                this.prevTransformMap.putAll(this.transformMap);
                this.transformMap.clear();
            }
        }
    }

    public static void addRotationAngle(class_630 model, float x, float y, float z) {
        model.field_3654 += x;
        model.field_3675 += y;
        model.field_3674 += z;
    }

    public static void resetAngles(class_630 ... boxes) {
        for (class_630 box : boxes) {
            Animator.resetAngles(box);
        }
    }

    public static void resetAngles(class_630 box) {
        box.field_3654 = 0.0f;
        box.field_3675 = 0.0f;
        box.field_3674 = 0.0f;
    }
}

