/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_5483;
import net.minecraft.class_6862;

public final class BiomeModificationsHandler {
    private BiomeModificationsHandler() {
    }

    public static void onRegisterBiomeModifications(BiomeModificationsContext context) {
        BiomeModificationsHandler.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_CREEPER_SPAWNS_BIOME_TAG, config -> config.mutantCreeperSpawnWeight, class_1299.field_6046, (class_1299)ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.comp_349());
        BiomeModificationsHandler.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_ENDERMAN_SPAWNS_BIOME_TAG, config -> config.mutantEndermanSpawnWeight, class_1299.field_6091, (class_1299)ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.comp_349());
        BiomeModificationsHandler.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_SKELETON_SPAWNS_BIOME_TAG, config -> config.mutantSkeletonSpawnWeight, class_1299.field_6137, (class_1299)ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.comp_349());
        BiomeModificationsHandler.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_ZOMBIE_SPAWNS_BIOME_TAG, config -> config.mutantZombieSpawnWeight, class_1299.field_6051, (class_1299)ModEntityTypes.MUTANT_ZOMBIE_ENTITY_TYPE.comp_349());
    }

    private static void registerMutantSpawn(BiomeModificationsContext context, class_6862<class_1959> withoutSpawnsTag, ToDoubleFunction<CommonConfig> spawnWeightGetter, class_1299<?> vanillaEntityType, class_1299<?> mutantEntityType) {
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> !biomeLoadingContext.is(withoutSpawnsTag), biomeModificationContext -> BiomeModificationsHandler.addMutantSpawn(biomeModificationContext.mobSpawnSettings(), spawnWeightGetter.applyAsDouble((CommonConfig)MutantMonsters.CONFIG.get(CommonConfig.class)), vanillaEntityType, mutantEntityType));
    }

    private static void addMutantSpawn(MobSpawnSettingsContext spawnSettings, double spawnWeight, class_1299<?> entityType, class_1299<?> mutantEntityType) {
        if (spawnWeight > 0.0) {
            spawnSettings.getSpawnerData(class_1311.field_6302).stream().filter(data -> data.field_9389 == entityType).findAny().ifPresent(spawnerData -> {
                int spawnerDataWeight = Math.max(1, (int)((double)spawnerData.method_34979().method_34976() * spawnWeight));
                spawnSettings.addSpawn(class_1311.field_6302, new class_5483.class_1964(mutantEntityType, spawnerDataWeight, 1, 1));
            });
            class_5483.class_5265 mobSpawnCost = spawnSettings.getSpawnCost(entityType);
            if (mobSpawnCost != null) {
                spawnSettings.setSpawnCost(mutantEntityType, mobSpawnCost.comp_1307(), mobSpawnCost.comp_1308());
            }
        }
    }
}

