/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.util;

import com.google.common.collect.ImmutableMap;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.mixin.accessor.RavagerAccessor;
import fuzs.mutantmonsters.network.S2CMutantLevelParticlesMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1427;
import net.minecraft.class_1451;
import net.minecraft.class_1496;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_4050;
import net.minecraft.class_5819;

public final class EntityUtil {
    private static final Map<class_1299<?>, class_1792> VANILLA_SKULLS_MAP = ImmutableMap.of((Object)class_1299.field_6046, (Object)class_1802.field_8681, (Object)class_1299.field_6051, (Object)class_1802.field_8470, (Object)class_1299.field_6137, (Object)class_1802.field_8398, (Object)class_1299.field_6076, (Object)class_1802.field_8791, (Object)class_1299.field_6116, (Object)class_1802.field_8712);

    private EntityUtil() {
    }

    public static float getHeadAngle(class_1309 livingEntity, double x, double z) {
        return class_3532.method_15356((float)((float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f), (float)livingEntity.field_6241);
    }

    public static void spawnLingeringCloud(class_1309 livingEntity) {
        Collection collection = livingEntity.method_6026();
        if (!collection.isEmpty()) {
            class_1295 areaEffectCloud = new class_1295(livingEntity.method_37908(), livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
            areaEffectCloud.method_5603(1.5f);
            areaEffectCloud.method_5609(-0.5f);
            areaEffectCloud.method_5595(10);
            areaEffectCloud.method_5604(areaEffectCloud.method_5605() / 2);
            areaEffectCloud.method_5596(-areaEffectCloud.method_5599() / (float)areaEffectCloud.method_5605());
            for (class_1293 effectinstance : collection) {
                areaEffectCloud.method_5610(new class_1293(effectinstance));
            }
            livingEntity.method_37908().method_8649((class_1297)areaEffectCloud);
        }
    }

    public static void stunRavager(class_1309 livingEntity) {
        if (livingEntity instanceof class_1584 && ((RavagerAccessor)livingEntity).mutantmonsters$getStunnedTick() == 0) {
            ((RavagerAccessor)livingEntity).mutantmonsters$setStunnedTick(40);
            livingEntity.method_5783(class_3417.field_14822, 1.0f, 1.0f);
            livingEntity.method_37908().method_8421((class_1297)livingEntity, (byte)39);
        }
    }

    public static void disableShield(class_1309 livingEntity, int ticks) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            if (livingEntity.method_6039()) {
                player.method_7357().method_7906(livingEntity.method_6030().method_7909(), ticks);
                livingEntity.method_6021();
                livingEntity.method_37908().method_8421((class_1297)livingEntity, (byte)30);
            }
        }
    }

    public static void sendPlayerVelocityPacket(class_1297 entity) {
        if (entity instanceof class_3222) {
            ((class_3222)entity).field_13987.method_14364((class_2596)new class_2743(entity));
        }
    }

    public static boolean isFeline(class_1309 livingEntity) {
        return livingEntity instanceof class_3701 || livingEntity instanceof class_1451;
    }

    public static boolean shouldAttackEntity(class_1309 target, class_1309 owner, boolean targetCreepers) {
        if (!(owner instanceof class_1657)) {
            return true;
        }
        if (target instanceof class_1548) {
            return targetCreepers;
        }
        if (target instanceof class_1321) {
            return !((class_1321)target).method_6171(owner);
        }
        if (target instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)target)) {
            return false;
        }
        if (target instanceof class_1427 && !(target instanceof class_1569)) {
            return false;
        }
        return !(target instanceof class_1496) || !((class_1496)target).method_6727();
    }

    public static void spawnEndersoulParticles(class_1297 entity, class_5819 random, int amount, float speed) {
        for (int i = 0; i < amount; ++i) {
            float f = (random.method_43057() - 0.5f) * speed;
            float f1 = (random.method_43057() - 0.5f) * speed;
            float f2 = (random.method_43057() - 0.5f) * speed;
            double tempX = entity.method_23317() + (double)((random.method_43057() - 0.5f) * entity.method_17681());
            double tempY = entity.method_23318() + (double)((random.method_43057() - 0.5f) * entity.method_17682()) + 0.5;
            double tempZ = entity.method_23321() + (double)((random.method_43057() - 0.5f) * entity.method_17681());
            entity.method_37908().method_8406((class_2394)ModRegistry.ENDERSOUL_PARTICLE_TYPE.comp_349(), tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendParticlePacket(class_1297 entity, class_2394 particleData, int amount) {
        double x = entity.method_23317();
        double y = entity.method_23318();
        double z = entity.method_23321();
        PlayerSet playerSet = PlayerSet.nearEntity((class_1297)entity);
        MutantMonsters.NETWORK.sendMessage(playerSet, new S2CMutantLevelParticlesMessage(particleData, x, y, z, entity.method_17681(), entity.method_17682(), entity.method_17681(), amount).toClientboundMessage());
    }

    public static class_243 getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new class_243((double)(-class_3532.method_15374((float)rad) * scale), 0.0, (double)(class_3532.method_15362((float)rad) * scale));
    }

    public static boolean teleportTo(class_1308 mob, double x, double y, double z) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        boolean success = false;
        if (mob.method_37908().method_8477((class_2338)pos)) {
            do {
                pos.method_10098(class_2350.field_11033);
            } while (pos.method_10264() > mob.method_37908().method_31607() && !mob.method_37908().method_8320((class_2338)pos).method_51366());
            pos.method_10098(class_2350.field_11036);
            class_238 bb = mob.method_18377(class_4050.field_18076).method_30231((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            if (mob.method_37908().method_8587((class_1297)mob, bb) && !mob.method_37908().method_22345(bb)) {
                success = true;
            }
        }
        if (!success) {
            return false;
        }
        mob.method_5942().method_6340();
        mob.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
        return true;
    }

    public static void divertAttackers(class_1308 targetedMob, class_1309 newTarget) {
        for (class_1308 attacker : targetedMob.method_37908().method_18467(class_1308.class, targetedMob.method_5829().method_1009(16.0, 10.0, 16.0))) {
            if (attacker == targetedMob || attacker.method_5968() != targetedMob) continue;
            attacker.method_5980(newTarget);
        }
    }

    public static class_1799 getSkullDrop(class_1299<?> entityType) {
        if (!VANILLA_SKULLS_MAP.containsKey(entityType)) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)VANILLA_SKULLS_MAP.get(entityType));
    }
}

