/*
 * Decompiled with CFR 0.152.
 */
package atonkish.quartzelv.gametest.testcase;

import atonkish.quartzelv.QuartzElevatorMod;
import atonkish.quartzelv.block.ModBlocks;
import atonkish.quartzelv.gametest.util.MockServerPlayerHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_4525;
import net.minecraft.class_4529;

public class TeleportTests {
    public static final String BATCH_ID_DEFAULT = "quartzelv:TeleportBatch";
    public static final String BATCH_ID_WITH_MIX_TYPES = "quartzelv:TeleportWithMixTypesBatch";
    public static final String BATCH_ID_WITH_PLAYER_ONLY = "quartzelv:TeleportWithPlayerOnlyBatch";
    public static final Collection<class_4529> TEST_FUNCTIONS = new ArrayList<class_4529>(){
        {
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Smooth Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Smooth Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Smooth Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Smooth Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, false));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, class_1299.field_6051, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, class_1299.field_6051, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, class_1299.field_6069, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, class_1299.field_6069, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Quartz Elevator to Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, class_1299.field_6102, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TeleportTests.BATCH_ID_DEFAULT, class_1299.field_6102, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TeleportTests.BATCH_ID_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Quartz Elevator to Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, class_1299.field_6051, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, false));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, class_1299.field_6051, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, false));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, class_1299.field_6069, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, false));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, class_1299.field_6069, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, false));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, class_1299.field_6102, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, false));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TeleportTests.BATCH_ID_WITH_PLAYER_ONLY, class_1299.field_6102, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, false));
        }
    };

    private static class_4529 createTestPlayerTeleportUp(String name, String batchId, class_2248 elevatorBlock1, class_2248 elevatorBlock2, int distance, boolean shouldTeleport) {
        String testName = String.format("%s %s %s", "quartzelv", TeleportTests.class.getSimpleName(), name).replace(" ", "_");
        return new class_4529(batchId, testName, "fabric-gametest-api-v1:empty", class_4525.method_29408((int)0), 100, 0L, true, false, 1, 1, false, context -> {
            class_2338 blockPos1 = class_2338.field_10980;
            class_2338 blockPos2 = class_2338.field_10980.method_10086(distance);
            context.method_35984(blockPos1, elevatorBlock1);
            context.method_35984(blockPos2, elevatorBlock2);
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)blockPos1.method_10086(1)));
            player.method_6043();
            try {
                context.method_35955((class_1297)player, (shouldTeleport ? blockPos2 : blockPos1).method_10086(1));
            }
            catch (Exception e) {
                QuartzElevatorMod.LOGGER.error(e.getMessage());
                throw e;
            }
            finally {
                MockServerPlayerHelper.destroy(context, player);
            }
            context.method_36036();
        });
    }

    private static <E extends class_1308> class_4529 createTestMobTeleportUp(String name, String batchId, class_1299<E> type, class_2248 elevatorBlock1, class_2248 elevatorBlock2, int distance, boolean shouldTeleport) {
        String testName = String.format("%s %s %s", "quartzelv", TeleportTests.class.getSimpleName(), name).replace(" ", "_");
        return new class_4529(batchId, testName, "fabric-gametest-api-v1:empty", class_4525.method_29408((int)0), 100, 0L, true, false, 1, 1, false, context -> {
            class_2338 blockPos1 = class_2338.field_10980;
            class_2338 blockPos2 = class_2338.field_10980.method_10086(distance);
            context.method_35984(blockPos1, elevatorBlock1);
            context.method_35984(blockPos2, elevatorBlock2);
            class_1308 mob = context.method_36009(type, blockPos1.method_10086(1));
            mob.method_6043();
            try {
                context.method_35955((class_1297)mob, (shouldTeleport ? blockPos2 : blockPos1).method_10086(1));
            }
            catch (Exception e) {
                QuartzElevatorMod.LOGGER.error(e.getMessage());
                throw e;
            }
            context.method_36036();
        });
    }

    private static class_4529 createTestPlayerTeleportDown(String name, String batchId, class_2248 elevatorBlock1, class_2248 elevatorBlock2, int distance, boolean shouldTeleport) {
        String testName = String.format("%s %s %s", "quartzelv", TeleportTests.class.getSimpleName(), name).replace(" ", "_");
        return new class_4529(batchId, testName, "fabric-gametest-api-v1:empty", class_4525.method_29408((int)0), 100, 0L, true, false, 1, 1, false, context -> {
            class_2338 blockPos1 = class_2338.field_10980.method_10086(distance);
            class_2338 blockPos2 = class_2338.field_10980;
            context.method_35984(blockPos1, elevatorBlock1);
            context.method_35984(blockPos2, elevatorBlock2);
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)blockPos1.method_10086(1)));
            player.method_5660(true);
            player.method_5660(false);
            try {
                context.method_35955((class_1297)player, (shouldTeleport ? blockPos2 : blockPos1).method_10086(1));
            }
            catch (Exception e) {
                QuartzElevatorMod.LOGGER.error(e.getMessage());
                throw e;
            }
            finally {
                MockServerPlayerHelper.destroy(context, player);
            }
            context.method_36036();
        });
    }
}

