/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.Dummy;
import net.mehvahdjukaar.amendments.common.FlowerPotHandler;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.events.behaviors.InteractEvents;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_5431;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Amendments {
    public static final String MOD_ID = "amendments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Amendments");
    public static final List<String> OLD_MODS = List.of("supplementaries", "carpeted", "betterlily", "betterjukebox");

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void init() {
        Dummy.MOD_LOADED = true;
        CommonConfigs.init();
        ModRegistry.init();
        ModNetwork.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientConfigs.init();
            AmendmentsClient.init();
        }
        PlatHelper.addCommonSetupAsync(Amendments::setupAsync);
        PlatHelper.addCommonSetup(Amendments::setup);
        PlatHelper.addReloadableCommonSetup(Amendments::onReload);
        RegHelper.addDynamicDispenserBehaviorRegistration(Amendments::registerDispenserBehaviors);
        RegHelper.registerSimpleRecipeCondition((class_2960)Amendments.res("flag"), CommonConfigs::isFlagOn);
        RegHelper.addItemsToTabsRegistration(Amendments::addItemsToTabs);
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent itemToTabEvent) {
        if (CommonConfigs.THROWABLE_FIRE_CHARGES.get().booleanValue()) {
            itemToTabEvent.addBefore(class_7706.field_40202, i -> i.method_31574(class_1802.field_8543), new class_1935[]{class_1802.field_8814});
            if (CommonConfigs.DRAGON_CHARGE.get().booleanValue()) {
                itemToTabEvent.addBefore(class_7706.field_40202, i -> i.method_31574(class_1802.field_8543), new class_1935[]{(class_1935)ModRegistry.DRAGON_CHARGE.get()});
            }
        }
    }

    private static void setup() {
        if (CommonConfigs.INVERSE_POTIONS.get() == null) {
            throw new IllegalStateException("Inverse potions config is null. How??");
        }
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.setup();
        }
        class_6880.class_6883 holder = class_7923.field_41128.method_40290(class_7477.field_39285);
        HashSet set = new HashSet(((class_4158)holder.comp_349()).comp_815);
        Set extraStates = Stream.of((class_2248)ModRegistry.LIQUID_CAULDRON.get(), ModRegistry.DYE_CAULDRON.get()).flatMap(block -> block.method_9595().method_11662().stream()).collect(Collectors.toSet());
        set.addAll(extraStates);
        ((class_4158)holder.comp_349()).comp_815 = set;
        class_7477.method_43990((class_6880)holder, extraStates);
        ModRegistry.registerAdditionalPlacements();
    }

    private static void setupAsync() {
        FlowerPotHandler.setup();
    }

    public static void onReload(class_5455 registryAccess, boolean client) {
        InteractEvents.setupOverrides();
        if (client) {
            AmendmentsClient.afterTagSetup();
        }
    }

    private static void registerDispenserBehaviors(DispenserHelper.Event event) {
        for (SoftFluid f : SoftFluidRegistry.get((class_5455)event.getRegistryAccess())) {
            Amendments.registerFluidBehavior(f, event);
        }
        if (CommonConfigs.FIRE_CHARGE_DISPENSER.get().booleanValue() && CommonConfigs.THROWABLE_FIRE_CHARGES.get().booleanValue()) {
            event.register(class_1802.field_8814, (class_2357)new class_2965(class_1802.field_8814){

                protected void method_10136(class_2342 source) {
                    source.comp_1967().method_20290(1018, source.comp_1968(), 0);
                }
            });
        }
        if (CommonConfigs.DRAGON_CHARGE.get().booleanValue()) {
            event.register(ModRegistry.DRAGON_CHARGE.get(), (class_2357)new class_2965(ModRegistry.DRAGON_CHARGE.get()){

                protected void method_10136(class_2342 source) {
                    source.comp_1967().method_20290(1018, source.comp_1968(), 0);
                }
            });
        }
    }

    public static void registerFluidBehavior(SoftFluid f, DispenserHelper.Event event) {
        HashSet<class_1792> itemSet = new HashSet<class_1792>();
        List categories = f.getContainerList().getCategories();
        for (FluidContainerList.Category c : categories) {
            for (class_1792 full : c.getFilledItems()) {
                if (full == class_1802.field_8162 || itemSet.contains(full)) continue;
                event.register((DispenserHelper.AdditionalDispenserBehavior)new CauldronConversion.DispenserBehavior(full));
                itemSet.add(full);
            }
        }
    }

    public static boolean isSupportingCeiling(class_2338 pos, class_4538 world) {
        return Amendments.isSupportingCeiling(world.method_8320(pos), pos, world);
    }

    public static boolean isSupportingCeiling(class_2680 upState, class_2338 pos, class_4538 world) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.isSupportingCeiling(upState, pos, world);
        }
        return class_2248.method_20044((class_4538)world, (class_2338)pos, (class_2350)class_2350.field_11033);
    }

    public static boolean canConnectDown(class_2680 neighborState, class_1936 level, class_2338 pos) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.canConnectDown(neighborState);
        }
        return neighborState.method_30368((class_1922)level, pos, class_2350.field_11036, class_5431.field_25823);
    }
}

