/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.client.BlockScanner;
import net.mehvahdjukaar.amendments.client.WallLanternModelsManager;
import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.mixins.SignRendererAccessor;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientResourceGenerator
extends DynClientResourcesGenerator {
    public ClientResourceGenerator() {
        super(new DynamicTexturePack(Amendments.res("generated_pack")));
    }

    public Collection<String> additionalNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("minecraft");
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue()) {
            PlatHelper.getInstalledMods().forEach(namespaces::add);
        }
        return namespaces;
    }

    public Logger getLogger() {
        return Amendments.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        WallLanternModelsManager.refreshModels(class_310.method_1551().method_1478());
        if (ClientConfigs.JUKEBOX_MODEL.get().booleanValue()) {
            executor.accept(this::generateJukeboxAssets);
        }
        if (CommonConfigs.DOUBLE_CAKES.get().booleanValue()) {
            executor.accept(this::generateDoubleCakesAssets);
        }
        if (ClientConfigs.SIGN_ATTACHMENT.get().booleanValue()) {
            executor.accept(this::generateHangingSignAssets);
        }
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue()) {
            executor.accept(this::generateSignTextures);
            if (CompatHandler.FARMERS_DELIGHT) {
                executor.accept(this::generateFdSignTextures);
            }
            executor.accept(this::generateSignBlockModels);
        }
        executor.accept((manager, sink) -> {
            if (ClientConfigs.COLORED_ARROWS.get().booleanValue()) {
                sink.addItemModel(class_2960.method_60656((String)"crossbow_arrow"), JsonParser.parseString((String)"{\n    \"parent\": \"item/crossbow\",\n    \"textures\": {\n        \"layer0\": \"item/crossbow_arrow_base\",\n        \"layer1\": \"item/crossbow_arrow_tip\"\n    }\n}\n"));
            }
            if (ClientConfigs.JUKEBOX_MODEL.get().booleanValue()) {
                sink.addItemModel(class_2960.method_60656((String)"jukebox"), JsonParser.parseString((String)"{\n  \"parent\": \"amendments:block/jukebox\"\n}\n"));
                sink.addBlockState(class_2960.method_60656((String)"jukebox"), JsonParser.parseString((String)"{\n  \"variants\": {\n    \"has_record=true\": {\n      \"model\": \"amendments:block/jukebox_on\"\n    },\n    \"has_record=false\": {\n      \"model\": \"amendments:block/jukebox\"\n    }\n  }\n}\n"));
            }
        });
    }

    private void generateSignTextures(class_3300 manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)64, (int)32, (int)64, (int)32).copyFrom(0, 16, 16, 16).to(0, 16).build();
        try (TextureImage template = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("entity/sign/template"));
             TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("entity/sign/mask"));){
            Respriter respriter = Respriter.masked((TextureImage)template, (TextureImage)mask);
            for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                class_2960 signTextureLocation;
                class_2248 sing = w.getBlockOfThis("sign");
                if (sing == null || (signTextureLocation = ClientResourceGenerator.findSignTexture(manager, w, sing, false)) == null) continue;
                try {
                    TextureImage signTexture = TextureImage.open((class_3300)manager, (class_2960)signTextureLocation);
                    try {
                        TextureImage modPlankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)w.planks));
                        try {
                            List palette = Palette.fromAnimatedImage((TextureImage)modPlankTexture);
                            for (Palette p : palette) {
                                p.remove(p.getLightest());
                            }
                            TextureImage newImage = respriter.recolorWithAnimation(palette, modPlankTexture.getMcMeta());
                            try {
                                transformer.apply(signTexture, newImage);
                                class_2960 blockLocation = Amendments.res("block/signs/" + w.getVariantId("sign"));
                                sink.addTexture(blockLocation, newImage);
                            }
                            finally {
                                if (newImage == null) continue;
                                newImage.close();
                            }
                        }
                        finally {
                            if (modPlankTexture == null) continue;
                            modPlankTexture.close();
                        }
                    }
                    finally {
                        if (signTexture == null) continue;
                        signTexture.close();
                    }
                }
                catch (Exception e) {
                    Amendments.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)w, (Object)e);
                }
            }
        }
        catch (Exception e) {
            Amendments.LOGGER.warn("Failed to generate sign extension textures, ", (Throwable)e);
        }
    }

    @Nullable
    private static class_2960 findSignTexture(class_3300 manager, WoodType w, class_2248 sing, boolean hanging) {
        class_4730 signMaterial;
        class_4719 vanilla = w.toVanilla();
        if (vanilla == null) {
            Amendments.LOGGER.error("Vanilla wood type for wood {} was null. This is a bug", (Object)w);
            return null;
        }
        class_4730 class_47302 = signMaterial = hanging ? class_4722.method_45781((class_4719)vanilla) : class_4722.method_33082((class_4719)vanilla);
        if (signMaterial == null) {
            try {
                class_2586 be = ((class_2343)sing).method_10123(class_2338.field_10980, sing.method_9564());
                class_827 renderer = class_310.method_1551().method_31975().method_3550(be);
                if (renderer instanceof SignRendererAccessor) {
                    SignRendererAccessor sr = (SignRendererAccessor)renderer;
                    signMaterial = sr.invokeGetSignMaterial(vanilla);
                }
            }
            catch (Exception e) {
                Amendments.LOGGER.error("Failed to get sign material for wood (from block entity renderer) {}, ", (Object)w, (Object)e);
            }
        }
        if (signMaterial == null) {
            class_2960 relativeLocation = w.getId().method_45138("entity/signs/" + (hanging ? "hanging/" : ""));
            class_2960 id = ResType.TEXTURES.getPath(relativeLocation);
            if (manager.method_14486(id).isPresent()) {
                return relativeLocation;
            }
        } else {
            return signMaterial.method_24147();
        }
        Amendments.LOGGER.error("Sign material for wood {} was null. This is likely due to some mod calling Sheets.getSignMaterial too early or by some wood mod not registering their wood type properly by not adding it to the vanilla texture map. Sheets.getSignMaterial is NOT Nullable, i shouldn't even have this check.", (Object)w);
        return null;
    }

    private static String joinNonEmpty(String first, String second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        return first + "_" + second;
    }

    private void generateFdSignTextures(class_3300 manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)64, (int)32, (int)64, (int)32).copyFrom(0, 12, 28, 2).to(0, 9).copyFrom(26, 2, 2, 14).to(18, 2).copyFrom(24, 7, 2, 10).to(16, 4).copyFrom(23, 2, 3, 3).to(15, 2).copyFrom(28, 2, 24, 12).to(20, 2).copyFrom(28, 12, 24, 2).to(20, 9).copyFrom(50, 2, 2, 8).to(34, 2).build();
        ArrayList<String> names = new ArrayList<String>();
        Arrays.stream(class_1767.values()).forEach(d -> names.add(d.method_7792()));
        names.add("");
        for (String d2 : names) {
            class_2960 texturePath = class_2960.method_60655((String)"farmersdelight", (String)ClientResourceGenerator.joinNonEmpty("entity/signs/canvas", d2));
            try {
                TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)texturePath);
                try {
                    TextureImage newImage = vanillaTexture.makeCopy();
                    try {
                        transformer.apply(vanillaTexture, newImage);
                        class_2960 blockTexturePath = Amendments.res("block/signs/farmersdelight/" + ClientResourceGenerator.joinNonEmpty(d2, "canvas_sign"));
                        sink.addTexture(blockTexturePath, newImage);
                    }
                    finally {
                        if (newImage == null) continue;
                        newImage.close();
                    }
                }
                finally {
                    if (vanillaTexture == null) continue;
                    vanillaTexture.close();
                }
            }
            catch (Exception e) {
                Amendments.LOGGER.warn("Failed to generate Farmers Delight sign extension texture for {}, ", (Object)d2, (Object)e);
            }
        }
    }

    private void generateSignBlockModels(class_3300 manager, ResourceSink sink) {
        AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.clear();
        StaticResource sign0 = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_0")));
        StaticResource sign1 = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_1")));
        StaticResource sign2 = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_2")));
        StaticResource sign3 = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_3")));
        StaticResource signWall = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_wall")));
        StaticResource blockState = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Amendments.res("sign_oak")));
        StaticResource blockStateWall = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Amendments.res("sign_oak_wall")));
        String blockStateText = new String(blockState.data, StandardCharsets.UTF_8);
        String blockStateWallText = new String(blockStateWall.data, StandardCharsets.UTF_8);
        for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
            class_2248 sign = w.getBlockOfThis("sign");
            class_2248 wallSign = w.getBlockOfThis("wall_sign");
            if (sign == null || wallSign == null) continue;
            String variantId = w.getVariantId("sign");
            sink.addSimilarJsonResource(manager, sign0, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, sign1, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, sign2, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, sign3, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, signWall, "sign_oak", variantId);
            sink.addBytes(Utils.getID((class_2248)sign), blockStateText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
            sink.addBytes(Utils.getID((class_2248)wallSign), blockStateWallText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
            AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(sign);
            AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(wallSign);
        }
        ArrayList<String> names = new ArrayList<String>();
        Arrays.stream(class_1767.values()).forEach(d -> names.add(d.method_7792() + "_"));
        names.add("");
        if (CompatHandler.FARMERS_DELIGHT) {
            for (class_2248 canvas : BlockScanner.getInstance().getFdSigns()) {
                class_2960 id = Utils.getID((class_2248)canvas);
                class_2248 canvasWall = class_7923.field_41175.method_17966(id.method_45134(p -> p.replace("sign", "wall_sign"))).orElse(null);
                if (canvasWall == null) continue;
                class_2960 canvasWallId = Utils.getID((class_2248)canvasWall);
                String variantId = "farmersdelight/" + id.method_12832();
                sink.addSimilarJsonResource(manager, sign0, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, sign1, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, sign2, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, sign3, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, signWall, "sign_oak", variantId);
                sink.addBytes(id, blockStateText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
                sink.addBytes(canvasWallId, blockStateWallText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
                AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(canvas);
                AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(canvasWall);
            }
        }
    }

    private void generateHangingSignAssets(class_3300 manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)32, (int)64, (int)16, (int)16).copyFrom(26, 0, 2, 4).to(4, 0).copyFrom(26, 8, 6, 8).to(4, 4).copyFrom(28, 24, 4, 8).to(0, 4).copyFrom(26, 20, 2, 4).to(6, 0).copyFrom(26, 28, 2, 8).to(10, 4).flippedX().build();
        for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
            class_2960 signTexturePath;
            class_2248 hangingSign = w.getBlockOfThis("hanging_sign");
            if (hangingSign == null || (signTexturePath = ClientResourceGenerator.findSignTexture(manager, w, hangingSign, true)) == null) continue;
            try {
                TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)signTexturePath);
                try {
                    TextureImage rotated = TextureOps.createRotated((TextureImage)vanillaTexture, (class_2470)class_2470.field_11463);
                    try {
                        TextureImage newIm = TextureOps.createScaled((TextureImage)vanillaTexture, (float)0.25f, (float)0.5f);
                        try {
                            newIm.clear();
                            transformer.apply(rotated, newIm);
                            sink.addTexture(Amendments.res("entity/signs/hanging/" + w.getVariantId("extension")), newIm);
                        }
                        finally {
                            if (newIm == null) continue;
                            newIm.close();
                        }
                    }
                    finally {
                        if (rotated == null) continue;
                        rotated.close();
                    }
                }
                finally {
                    if (vanillaTexture == null) continue;
                    vanillaTexture.close();
                }
            }
            catch (Exception e) {
                Amendments.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)w, (Object)e);
            }
        }
        if (CompatHandler.FARMERS_DELIGHT) {
            try (TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)class_2960.method_60655((String)"farmersdelight", (String)"entity/signs/hanging/canvas"));
                 TextureImage rotated = TextureOps.createRotated((TextureImage)vanillaTexture, (class_2470)class_2470.field_11463);
                 TextureImage newIm = TextureOps.createScaled((TextureImage)rotated, (float)0.5f, (float)0.25f);){
                newIm.clear();
                transformer.apply(rotated, newIm);
                sink.addTexture(Amendments.res("entity/signs/hanging/farmersdelight/extension_canvas"), newIm);
            }
            catch (Exception e) {
                Amendments.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)"canvas sign", (Object)e);
            }
        }
    }

    private void generateJukeboxAssets(class_3300 manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)16, (int)16, (int)16, (int)16).copyFrom(5, 6, 3, 2).to(6, 6).copyFrom(8, 6, 1, 1).to(9, 7).copyFrom(7, 7, 3, 2).to(7, 8).copyFrom(6, 8, 1, 1).to(6, 8).copyFrom(9, 6, 1, 1).to(9, 6).copyFrom(5, 8, 1, 1).to(6, 9).build();
        try (TextureImage fallback = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("block/music_discs/music_disc_generic"));
             TextureImage template = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("block/music_discs/music_disc_template"));
             TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("block/music_discs/music_disc_mask"));){
            Respriter respriter = Respriter.of((TextureImage)template);
            for (Map.Entry<class_1792, class_4730> e : AmendmentsClient.getAllRecords().entrySet()) {
                class_2960 texturePath = Amendments.res(e.getValue().method_24147().method_12832());
                if (sink.alreadyHasTextureAtLocation(manager, texturePath)) continue;
                try {
                    TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)e.getKey()));
                    try {
                        Palette p = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)mask);
                        ClientResourceGenerator.amendJukeboxPalette(p);
                        TextureImage newImage = respriter.recolor(p);
                        try {
                            transformer.apply(vanillaTexture, newImage);
                            if (newImage.getPixel(6, 6) == p.get(p.size() - 2).rgb().toInt()) {
                                newImage.setPixel(6, 6, p.getLightest().value());
                                newImage.setPixel(9, 9, p.getLightest().value());
                            }
                            sink.addTexture(texturePath, newImage);
                        }
                        finally {
                            if (newImage == null) continue;
                            newImage.close();
                        }
                    }
                    finally {
                        if (vanillaTexture == null) continue;
                        vanillaTexture.close();
                    }
                }
                catch (Exception ex) {
                    this.getLogger().warn("Failed to generate record item texture for {}. No model / texture found", (Object)e.getKey());
                    sink.addTexture(texturePath, fallback);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void amendJukeboxPalette(Palette p) {
        float averLum = p.getAverageLuminanceStep();
        if ((double)averLum > 0.06) {
            p.increaseInner();
        }
        PaletteColor darkest = p.getDarkest();
        PaletteColor beforeDarkest = p.get(1);
        if ((double)(beforeDarkest.luminance() - darkest.luminance()) > (double)averLum - 0.005) {
            p.remove(darkest);
            p.increaseDown();
        }
    }

    private void generateDoubleCakesAssets(class_3300 manager, ResourceSink sink) {
        StaticResource[] cakeModels = (StaticResource[])Stream.of("full", "slice1", "slice2", "slice3", "slice4", "slice5", "slice6").map(s -> StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Amendments.res("double_cake/vanilla_" + s)))).toArray(StaticResource[]::new);
        StaticResource doubleCakeModelState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Amendments.res("double_cake")));
        for (CakeRegistry.CakeType t : CakeRegistry.INSTANCE.getValues()) {
            if (t.isVanilla()) continue;
            try {
                class_2960 dcId = Utils.getID((class_2248)t.getBlockOfThis("double_cake"));
                class_2960 top = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("top"));
                class_2960 side = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("side"));
                class_2960 bottom = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("bottom"));
                class_2960 inner = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("inner"));
                for (StaticResource m : cakeModels) {
                    sink.addSimilarJsonResource(manager, m, s -> s.replace("amendments:block/double_cake", "").replace("minecraft:block/cake", "").replace("\"/", "\"amendments:block/double_cake/").replace("_top", top.toString()).replace("_side", side.toString()).replace("_inner", inner.toString()).replace("_bottom", bottom.toString()), s -> s.replace("vanilla", dcId.method_12832()));
                }
                sink.addSimilarJsonResource(manager, doubleCakeModelState, s -> s.replace("vanilla", dcId.method_12832()), s -> s.replace("double_cake", dcId.method_12832()));
            }
            catch (Exception e) {
                Amendments.LOGGER.error("Failed to generate model for double cake {},", (Object)t);
            }
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent languageEvent) {
        if (languageEvent.isDefault()) {
            languageEvent.addEntry("item.minecraft.lingering_potion.effect.empty", "Lingering Mixed Potion");
            languageEvent.addEntry("item.minecraft.splash_potion.effect.empty", "Splash Mixed Potion");
            languageEvent.addEntry("item.minecraft.potion.effect.empty", "Mixed Potion");
        }
    }
}

