/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.client.BlockScanner;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_773;
import org.jetbrains.annotations.Nullable;

public class WallLanternModelsManager {
    private static final Map<class_2248, class_2960> SPECIAL_MOUNT_TEXTURES = new IdentityHashMap<class_2248, class_2960>();
    private static final Map<class_2248, class_1091> SPECIAL_LANTERN_MODELS = new IdentityHashMap<class_2248, class_1091>();

    public static void refreshModels(class_3300 manager) {
        WallLanternModelsManager.reloadTextures(manager);
        WallLanternModelsManager.reloadModels(manager);
    }

    private static void reloadModels(class_3300 manager) {
        SPECIAL_LANTERN_MODELS.clear();
        for (class_2248 l : BlockScanner.getInstance().getLanterns()) {
            class_2960 reg = Utils.getID((class_2248)l);
            Object namespace = reg.method_12836().equals("minecraft") || reg.method_12836().equals("amendments") ? "" : reg.method_12836() + "/";
            String s = "block/custom_wall_lanterns/" + (String)namespace + reg.method_12832();
            class_2960 fullPath = Amendments.res("models/" + s + ".json");
            Optional resource = manager.method_14486(fullPath);
            if (!resource.isPresent()) continue;
            SPECIAL_LANTERN_MODELS.put(l, RenderUtil.getStandaloneModelLocation((class_2960)Amendments.res(s)));
        }
    }

    private static void reloadTextures(class_3300 manager) {
        SPECIAL_MOUNT_TEXTURES.clear();
        for (class_2248 l : BlockScanner.getInstance().getLanterns()) {
            class_2960 reg = Utils.getID((class_2248)l);
            Object namespace = reg.method_12836().equals("minecraft") || reg.method_12836().equals("amendments") ? "" : reg.method_12836() + "/";
            String s = "textures/block/wall_lanterns/" + (String)namespace + reg.method_12832() + ".json";
            class_2960 fullPath = Amendments.res(s);
            Optional resource = manager.method_14486(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((class_3298)resource.get()).method_14482();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_MOUNT_TEXTURES.put(l, class_2960.method_12829((String)texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static class_1058 getTexture(class_2248 block) {
        class_2960 res = SPECIAL_MOUNT_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(res);
    }

    public static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        SPECIAL_LANTERN_MODELS.values().forEach(e -> event.register(e.comp_2875()));
    }

    public static class_1087 getModel(class_773 blockModelShaper, class_2680 lantern) {
        class_1091 special = SPECIAL_LANTERN_MODELS.get(lantern.method_26204());
        if (special != null) {
            return ClientHelper.getModel((class_1092)class_310.method_1551().method_1554(), (class_1091)special);
        }
        return blockModelShaper.method_3335(lantern);
    }
}

