/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.mehvahdjukaar.amendments.common.block.CommonCauldronCode;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.AlexCavesCompat;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5253;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidCauldronBlock
extends ModCauldronBlock {
    public static final MapCodec<LiquidCauldronBlock> CODEC = LiquidCauldronBlock.method_54094(LiquidCauldronBlock::new);
    public static final class_2758 LEVEL = PlatHelper.getPlatform().isFabric() ? class_2741.field_12513 : ModBlockProperties.LEVEL_1_4;
    public static final class_2758 LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;

    public LiquidCauldronBlock(class_4970.class_2251 properties) {
        super(properties.method_9631(value -> (Integer)value.method_11654((class_2769)LIGHT_LEVEL)));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(1))).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends LiquidCauldronBlock> method_53969() {
        return CODEC;
    }

    @Override
    public class_2758 getLevelProperty() {
        return LEVEL;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LEVEL, LIGHT_LEVEL});
    }

    protected boolean method_32765(class_3611 fluid) {
        return true;
    }

    public void method_32764(class_2680 state, class_1937 level, class_2338 pos, class_3611 fluid) {
        class_2586 class_25862;
        if (!this.method_32766(state) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            SoftFluidStack sf;
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            int amount = SoftFluid.BOTTLE_COUNT;
            if (!CommonConfigs.LAVA_LAYERS.get().booleanValue() && fluid == class_3612.field_15908) {
                amount = SoftFluid.BUCKET_COUNT;
            }
            if (!(sf = SoftFluidStack.fromFluid((class_3611)fluid, (int)amount, null)).isEmpty() && te.getSoftFluidTank().addFluid(sf, false) != 0) {
                te.method_5431();
                level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
                if (fluid == class_3612.field_15908) {
                    level.method_20290(1046, pos, 0);
                } else {
                    level.method_20290(1047, pos, 0);
                }
            }
        }
    }

    @Override
    public void method_9504(class_2680 state, class_1937 level, class_2338 pos, class_1959.class_1963 precipitation) {
        class_2586 class_25862;
        super.method_9504(state, level, pos, precipitation);
        if (!this.method_32766(state) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            SoftFluidTank softFluidTank = te.getSoftFluidTank();
            SoftFluidStack sf = softFluidTank.getFluid();
            if (precipitation == class_1959.class_1963.field_9382 && sf.is(MLBuiltinSoftFluids.WATER) && softFluidTank.addFluid(SoftFluidStack.fromFluid((class_3611)class_3612.field_15910, (int)1, null), false) > 0) {
                level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
                te.method_5431();
            }
        }
    }

    @Override
    protected void handleEntityInsideFluidSpecial(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        class_2586 class_25862;
        if (entity.method_36971(level, pos) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            class_1542 ie;
            LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)class_25862;
            SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
            PotionBottleType potType = this.getPotType(fluid);
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                if (potType != null && potType != PotionBottleType.REGULAR && this.applyPotionFluidEffects(level, pos, living, fluid)) {
                    tile.consumeOneLayer();
                    level.method_33596(entity, (class_6880)class_5712.field_28733, pos);
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidDamage(fluid, level, pos, state, entity);
                }
            }
            if (!tile.isGlowing() && fluid.is(ModTags.CAN_GLOW) && entity instanceof class_1542 && (ie = (class_1542)entity).method_6983().method_31574(class_1802.field_28410) && this.method_31616(state, pos, entity)) {
                CommonCauldronCode.playSplashEffects(entity, this.method_31615(state));
                tile.setGlowing(true);
                level.method_33596(entity, (class_6880)class_5712.field_28733, pos);
                ie.method_6983().method_7934(1);
                if (ie.method_6983().method_7960()) {
                    ie.method_31472();
                }
            }
        }
    }

    private boolean applyPotionFluidEffects(class_1937 level, class_2338 pos, class_1309 living, SoftFluidStack stack) {
        List<class_1293> effects = this.getPotionEffects(stack);
        boolean success = false;
        for (class_1293 effect : effects) {
            class_6880 ef = effect.method_5579();
            if (living.method_6059(ef)) continue;
            if (((class_1291)ef.comp_349()).method_5561()) {
                ((class_1291)ef.comp_349()).method_5564(null, null, living, effect.method_5578(), 1.0);
            } else {
                living.method_6092(new class_1293(effect));
            }
            success = true;
        }
        if (success) {
            level.method_8396(null, pos, class_3417.field_14737, class_3419.field_15245, 1.0f, 1.0f);
        }
        return success;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
        super.method_9496(state, level, pos, rand);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            SoftFluidTank tank = te.getSoftFluidTank();
            if (level.field_9229.method_43048(4) == 0) {
                SoftFluidStack fluid = tank.getFluid();
                PotionBottleType type = this.getPotType(fluid);
                double height = this.method_31615(state);
                if (type != null) {
                    if (LiquidCauldronBlock.getAllPotionEffects(fluid).size() >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
                        CommonCauldronCode.addSurfaceParticles((class_2394)class_2398.field_11251, level, pos, 2, height, rand, 0.0f, 0.0f, 0.0f);
                    }
                    if (type != PotionBottleType.REGULAR) {
                        int color = tank.getCachedParticleColor((class_1920)level, pos);
                        int alpha = type == PotionBottleType.SPLASH ? class_3532.method_15375((float)38.25f) : 255;
                        class_9381 particle = class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)alpha, (int)color));
                        this.addPotionParticles((class_2394)particle, level, pos, 1, height, rand, color);
                    }
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidParticles(fluid, level, pos, rand, height);
                }
                class_2338 blockPos = pos.method_10084();
                if (fluid.is(MLBuiltinSoftFluids.LAVA) && level.method_8320(blockPos).method_26215() && !level.method_8320(blockPos).method_26216((class_1922)level, blockPos)) {
                    class_243 c = pos.method_46558();
                    if (rand.method_43048(20) == 0) {
                        CommonCauldronCode.addSurfaceParticles((class_2394)class_2398.field_11239, level, pos, 1, height, rand, 0.0f, 0.0f, 0.0f);
                        level.method_8486(c.field_1352, height, c.field_1350, class_3417.field_14576, class_3419.field_15245, 0.2f + rand.method_43057() * 0.2f, 0.9f + rand.method_43057() * 0.15f, false);
                    }
                    if (rand.method_43048(40) == 0) {
                        level.method_8486(c.field_1352, height, c.field_1350, class_3417.field_15021, class_3419.field_15245, 0.2f + rand.method_43057() * 0.2f, 0.9f + rand.method_43057() * 0.15f, false);
                    }
                }
            }
        }
    }

    @NotNull
    public static ArrayList<class_1293> getAllPotionEffects(SoftFluidStack fluid) {
        return Lists.newArrayList((Iterable)((class_1844)fluid.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).method_57397());
    }

    @Nullable
    private PotionBottleType getPotType(SoftFluidStack stack) {
        if (stack.is(MLBuiltinSoftFluids.POTION)) {
            return (PotionBottleType)stack.method_57825((class_9331)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.REGULAR);
        }
        return null;
    }

    private List<class_1293> getPotionEffects(SoftFluidStack stack) {
        return StreamSupport.stream(((class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).method_57397().spliterator(), false).toList();
    }

    private void addPotionParticles(class_2394 type, class_1937 level, class_2338 pos, int count, double surface, class_5819 rand, int color) {
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        CommonCauldronCode.addSurfaceParticles(type, level, pos, count, surface, rand, r, g, b);
    }

    @Override
    public class_2680 updateStateOnFluidChange(class_2680 state, class_1937 level, class_2338 pos, SoftFluidStack fluid) {
        class_2680 exploded = this.maybeExplode(state, level, pos, fluid);
        if (exploded != null) {
            return exploded;
        }
        int light = fluid.fluid().getLuminosity();
        if (light != (Integer)state.method_11654((class_2769)ModBlockProperties.LIGHT_LEVEL)) {
            state = (class_2680)state.method_11657((class_2769)ModBlockProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(light));
        }
        return super.updateStateOnFluidChange(state, level, pos, fluid);
    }

    @Nullable
    private class_2680 maybeExplode(class_2680 state, class_1937 level, class_2338 pos, SoftFluidStack fluid) {
        ArrayList<class_1293> potionEffects = LiquidCauldronBlock.getAllPotionEffects(fluid);
        int potionEffectAmount = potionEffects.size();
        if (potionEffectAmount >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
            if (potionEffectAmount > CommonConfigs.POTION_MIXING_LIMIT.get()) {
                level.method_22352(pos, true);
                class_243 vec3 = pos.method_46558();
                level.method_55117(null, level.method_48963().method_48808(vec3), null, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.4f, false, class_1937.class_7867.field_40888);
                return state;
            }
            if (level.field_9236) {
                CommonCauldronCode.addSurfaceParticles((class_2394)class_2398.field_11251, level, pos, 12, this.method_31615(state), level.field_9229, 0.0f, 0.0f, 0.0f);
            }
            level.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 1.0f, 1.0f);
            return null;
        }
        Map<class_1291, class_1291> inverse = CommonConfigs.INVERSE_POTIONS.get();
        List<class_1291> effects = potionEffects.stream().map(e -> (class_1291)e.method_5579().comp_349()).toList();
        for (class_1291 effect : effects) {
            class_1291 inv = inverse.get(effect);
            if (inv == null || !effects.contains(inv)) continue;
            if (level.field_9236) {
                CommonCauldronCode.addSurfaceParticles((class_2394)class_2398.field_11203, level, pos, 8, this.method_31615(state), level.field_9229, 0.0f, 0.01f + level.field_9229.method_43057() * 0.1f, 0.0f);
            }
            level.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 1.0f, 1.0f);
            return class_2246.field_10593.method_9564();
        }
        return null;
    }
}

