/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.amendments.common.network.ClientBoundFireballExplodePacket;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4770;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class FireballExplosion
extends class_1927 {
    private final float maxDamage;
    private final boolean hasKnockback;
    private final int onFireSeconds;
    private final float soundVolume;
    private final Set<class_2338> visitedBlock = new HashSet<class_2338>();

    public static FireballExplosion explodeServer(class_1937 serverLevel, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction) {
        return FireballExplosion.explodeServer(serverLevel, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, new ExtraSettings());
    }

    public static FireballExplosion explodeServer(class_1937 serverLevel, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction, ExtraSettings settings) {
        FireballExplosion explosion = FireballExplosion.explode(serverLevel, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, false, (class_6880<class_3414>)ModRegistry.FIREBALL_EXPLOSION_SOUND.getHolder(), settings);
        if (!(serverLevel instanceof class_3218)) {
            return explosion;
        }
        class_3218 sl = (class_3218)serverLevel;
        if (!explosion.method_46667()) {
            explosion.method_8352();
        }
        for (class_3222 serverPlayer : sl.method_18456()) {
            if (!(serverPlayer.method_5649(x, y, z) < 4096.0)) continue;
            NetworkHelper.sendToClientPlayer((class_3222)serverPlayer, (class_8710)new ClientBoundFireballExplodePacket(x, y, z, radius, explosion.method_8346(), (class_243)explosion.method_8351().get(serverPlayer), explosion.method_55111(), explosion.method_55112(), explosion.method_55113(), (class_6880<class_3414>)explosion.method_55114(), explosion.soundVolume));
        }
        return explosion;
    }

    public static FireballExplosion explode(class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction, boolean spawnParticles, class_6880<class_3414> explosionSound, ExtraSettings settings) {
        class_1927.class_4179 blockInteraction = switch (explosionInteraction) {
            case class_1937.class_7867.field_40888 -> class_1927.class_4179.field_40878;
            case class_1937.class_7867.field_40889 -> level.method_46669(class_1928.field_40880);
            case class_1937.class_7867.field_40890 -> level.method_8450().method_8355(class_1928.field_19388) ? level.method_46669(class_1928.field_40881) : class_1927.class_4179.field_40878;
            case class_1937.class_7867.field_40891 -> level.method_46669(class_1928.field_40882);
            case class_1937.class_7867.field_51779 -> class_1927.class_4179.field_47331;
            default -> throw new MatchException(null, null);
        };
        FireballExplosion explosion = new FireballExplosion(level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction, (class_2394)class_2398.field_11221, (class_2394)class_2398.field_11221, explosionSound, settings);
        explosion.method_8348();
        explosion.method_8350(spawnParticles);
        return explosion;
    }

    public FireballExplosion(class_1937 level, @Nullable class_1297 source, double toBlowX, double toBlowY, double toBlowZ, float radius, List<class_2338> positions, class_1927.class_4179 blockInteraction, class_2394 smallExplosionParticles, class_2394 largeExplosionParticles, class_6880<class_3414> explosionSound, ExtraSettings settings) {
        super(level, source, toBlowX, toBlowY, toBlowZ, radius, positions, blockInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound);
        this.onFireSeconds = settings.onFireSeconds;
        this.maxDamage = settings.maxDamage;
        this.hasKnockback = settings.hasKnockback;
        this.soundVolume = settings.soundVolume;
    }

    public FireballExplosion(class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, class_1927.class_4179 blockInteraction, class_2394 smallExplosionParticles, class_2394 largeExplosionParticles, class_6880<class_3414> explosionSound, ExtraSettings settings) {
        super(level, source, damageSource, damageCalculator, toBlowX, toBlowY, toBlowZ, radius, fire, blockInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound);
        this.onFireSeconds = settings.onFireSeconds;
        this.maxDamage = settings.maxDamage;
        this.hasKnockback = settings.hasKnockback;
        this.soundVolume = settings.soundVolume;
    }

    public void method_8348() {
        super.method_8348();
        if (!this.hasKnockback) {
            this.method_8351().clear();
        }
    }

    public void method_8350(boolean spawnParticles) {
        super.method_8350(false);
        if (spawnParticles) {
            this.field_9187.method_8406((class_2394)ModRegistry.FIREBALL_EMITTER_PARTICLE.get(), this.field_9195, this.field_9192, this.field_9189, (double)this.field_9190, 0.0, 0.0);
        }
        if (!this.field_9186) {
            return;
        }
        for (class_2338 pos : this.visitedBlock) {
            class_2680 state = this.field_9187.method_8320(pos);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof ILightable) {
                ILightable l = (ILightable)class_22482;
                l.lightableInteractWithEntity(this.field_9187, state, this.method_46406(), pos);
                continue;
            }
            if (state.method_26204() != class_2246.field_10124) continue;
            this.field_9187.method_8501(pos, class_4770.method_24416((class_1922)this.field_9187, (class_2338)pos));
        }
    }

    public boolean hasKnockback() {
        return this.hasKnockback;
    }

    public boolean hurtHitEntity(class_1297 entity, class_1282 source, float amount) {
        if (this.maxDamage > 0.0f && amount > this.maxDamage) {
            amount = this.maxDamage;
        }
        int oldFire = entity.method_20802();
        entity.method_5639((float)this.onFireSeconds);
        if (!entity.method_5643(source, amount)) {
            entity.method_20803(oldFire);
            return false;
        }
        return true;
    }

    public void addVisitedBlock(class_2338 pos, class_2680 state) {
        this.visitedBlock.add(pos);
    }

    public float getExplosionVolume() {
        return this.soundVolume;
    }

    public static class ExtraSettings {
        public float soundVolume = 4.0f;
        public float maxDamage = Float.MAX_VALUE;
        public int onFireSeconds = 0;
        public boolean hasKnockback = false;
    }
}

