/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.amendments.common.block.CommonCauldronCode;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5546;
import net.minecraft.class_5556;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class CauldronConversion
implements BlockUse {
    @Override
    public boolean isEnabled() {
        return CommonConfigs.LIQUID_CAULDRON.get();
    }

    @Override
    public boolean appliesToBlock(class_2248 block) {
        return class_2246.field_10593 == block;
    }

    @Override
    public class_1269 tryPerformingAction(class_2680 state, class_2338 pos, class_1937 level, class_1657 player, class_1268 hand, class_1799 stack, class_3965 hit) {
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        return null;
    }

    public static class_9062 convert(class_2680 state, class_2338 pos, class_1937 level, class_1657 player, class_1268 hand, class_1799 stack, boolean checkCauldronInteractions) {
        class_2586 class_25862;
        class_2680 newState = CauldronConversion.getNewState(pos, level, stack, checkCauldronInteractions);
        if (newState != null && level.method_8501(pos, newState) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            if (te.interactWithPlayerItem(player, hand, stack)) {
                return class_9062.method_55644((boolean)level.field_9236);
            }
            level.method_8501(pos, state);
            return class_9062.field_47731;
        }
        return class_9062.field_47731;
    }

    public static class_2680 getNewState(class_2338 pos, class_1937 level, class_1799 stack) {
        return CauldronConversion.getNewState(pos, level, stack, true);
    }

    @Nullable
    public static class_2680 getNewState(class_2338 pos, class_1937 level, class_1799 fluidBottle, boolean checkCauldronInteractions) {
        Pair fluid = SoftFluidStack.fromItem((class_1799)fluidBottle);
        if (fluid == null) {
            return null;
        }
        SoftFluidStack first = (SoftFluidStack)fluid.getFirst();
        if (first.is(MLBuiltinSoftFluids.WATER) && (fluidBottle.method_31574(class_1802.field_8150) || fluidBottle.method_31574(class_1802.field_8436))) {
            return null;
        }
        if (checkCauldronInteractions && ((class_5546)class_2246.field_10593).field_27084.comp_1982().containsKey(fluidBottle.method_7909()) && !first.is(MLBuiltinSoftFluids.POTION)) {
            return null;
        }
        if (CompatHandler.RATS && fluidBottle.method_31574(class_1802.field_8103)) {
            return null;
        }
        return CauldronConversion.getNewState(pos, level, first);
    }

    @Nullable
    public static class_2680 getNewState(class_2338 pos, class_1937 level, SoftFluidStack fluid) {
        if (fluid.isEmpty()) {
            return class_2246.field_10593.method_9564();
        }
        if (fluid.is(MLBuiltinSoftFluids.WATER)) {
            return (class_2680)((class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(Math.min(3, fluid.getCount())))).method_11657((class_2769)LiquidCauldronBlock.BOILING, (Comparable)Boolean.valueOf(CommonCauldronCode.shouldBoil(level.method_8320(pos.method_10074()), fluid, (class_1936)level, pos.method_10074())));
        }
        if (fluid.is(MLBuiltinSoftFluids.POWDERED_SNOW) && fluid.getCount() == 4) {
            return class_2246.field_27878.method_9564();
        }
        if (fluid.is(MLBuiltinSoftFluids.LAVA) && fluid.getCount() == 4) {
            return class_2246.field_27098.method_9564();
        }
        if (!fluid.is(ModTags.CAULDRON_BLACKLIST)) {
            class_2680 newState = fluid.is(ModRegistry.DYE_SOFT_FLUID) ? ModRegistry.DYE_CAULDRON.get().method_9564() : ModRegistry.LIQUID_CAULDRON.get().method_9564();
            class_2338 belowPos = pos.method_10074();
            return (class_2680)newState.method_11657((class_2769)LiquidCauldronBlock.BOILING, (Comparable)Boolean.valueOf(CommonCauldronCode.shouldBoil(level.method_8320(belowPos), fluid, (class_1936)level, belowPos)));
        }
        return null;
    }

    public static void setCorrectCauldronStateAndTile(class_2680 state, class_1937 level, class_2338 pos, SoftFluidStack resultFluid) {
        class_2680 newState = CauldronConversion.getNewState(pos, level, resultFluid);
        if (newState != null) {
            LiquidCauldronBlockTile te;
            class_2586 class_25862;
            if (state != newState) {
                level.method_8501(pos, newState);
            }
            if ((class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile && (class_25862 = (te = (LiquidCauldronBlockTile)class_25862).method_11010().method_26204()) instanceof ModCauldronBlock) {
                ModCauldronBlock mc = (ModCauldronBlock)class_25862;
                te.getSoftFluidTank().setFluid(resultFluid);
                te.method_5431();
            }
        }
    }

    public static class DispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        public DispenserBehavior(class_1792 item) {
            super(item);
        }

        protected class_1271<class_1799> customBehavior(class_2342 source, class_1799 stack) {
            class_3218 level = source.comp_1967();
            class_2680 originalState = source.comp_1969();
            class_2338 pos = source.comp_1968().method_10093((class_2350)originalState.method_11654((class_2769)class_2315.field_10918));
            if (!originalState.method_27852(class_2246.field_10593)) {
                return class_1271.method_22430((Object)stack);
            }
            class_2680 newState = CauldronConversion.getNewState(pos, (class_1937)level, stack);
            if (newState != null) {
                level.method_8501(pos, newState);
                class_2586 class_25862 = level.method_8321(pos);
                if (class_25862 instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
                    SoftFluidTank tank = te.getSoftFluidTank();
                    class_1799 returnStack = tank.interactWithItem(stack, (class_1937)level, pos, false);
                    if (returnStack != null) {
                        level.method_33596(null, (class_6880)class_5712.field_28733, pos);
                        return class_1271.method_22427((Object)returnStack);
                    }
                    level.method_8501(pos, originalState);
                }
            }
            return class_1271.method_22430((Object)stack);
        }
    }
}

