/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.collect.Maps;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.ClothConfigIntegration;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;

public class ModMenuIntegration
implements ModMenuApi {
    private Map<String, ConfigScreenFactory<?>> cachedFactories;

    public Map<String, ConfigScreenFactory<?>> factories() {
        if (this.cachedFactories == null) {
            Kiwi.onInitialize();
            if (Platform.isModLoaded("cloth-config")) {
                List<String> mods = KiwiConfigManager.getModsWithScreen(ClothConfigIntegration.attributes());
                HashMap factories = Maps.newHashMap();
                for (String mod : mods) {
                    factories.put(mod, $ -> ClothConfigIntegration.create($, mod));
                }
                this.cachedFactories = Map.copyOf(factories);
            } else {
                this.cachedFactories = Map.of();
            }
        }
        return this.cachedFactories;
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return this.factories().getOrDefault("kiwi", screen -> null);
    }

    public Map<String, ConfigScreenFactory<?>> getProvidedConfigScreenFactories() {
        return this.factories();
    }
}

