/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.contributor.ContributorsClient;
import snownee.kiwi.contributor.ITierProvider;
import snownee.kiwi.contributor.impl.KiwiTierProvider;
import snownee.kiwi.contributor.network.SSyncCosmeticPacket;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.network.KPacketSender;

@KiwiModule(value="contributors")
@KiwiModule.ClientCompanion(value=ContributorsClient.class)
public class Contributors
extends AbstractModule {
    public static final Map<String, ITierProvider> REWARD_PROVIDERS = Maps.newConcurrentMap();
    public static final Map<String, class_2960> PLAYER_COSMETICS = Maps.newConcurrentMap();
    private static final Set<class_2960> RENDERABLES = Sets.newLinkedHashSet();
    private static int DAY = Calendar.getInstance().get(5);

    public static boolean isContributor(String author, String playerName) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName);
    }

    public static boolean isContributor(String author, String playerName, String tier) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName, tier);
    }

    public static boolean isContributor(String author, class_1657 player) {
        return Contributors.isContributor(author, player.method_7334().getName());
    }

    public static boolean isContributor(String author, class_1657 player, String tier) {
        return Contributors.isContributor(author, player.method_7334().getName(), tier);
    }

    public static Set<class_2960> getPlayerTiers(String playerName) {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getPlayerTiers(playerName).stream().map(s -> class_2960.method_60655((String)tp.getAuthor().toLowerCase(Locale.ENGLISH), (String)s))).collect(Collectors.toSet());
    }

    public static Set<class_2960> getTiers() {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getTiers().stream().map(s -> class_2960.method_60655((String)tp.getAuthor().toLowerCase(Locale.ENGLISH), (String)s))).collect(Collectors.toSet());
    }

    public static void registerTierProvider(ITierProvider rewardProvider) {
        String namespace = rewardProvider.getAuthor().toLowerCase(Locale.ENGLISH);
        REWARD_PROVIDERS.put(namespace, rewardProvider);
        for (String tier : rewardProvider.getRenderableTiers()) {
            RENDERABLES.add(class_2960.method_60655((String)namespace, (String)tier));
        }
    }

    public static void changeCosmetic(class_3222 player, class_2960 cosmetic) {
        String playerName = player.method_7334().getName();
        Contributors.canPlayerUseCosmetic(playerName, cosmetic).thenAccept(bl -> {
            if (bl.booleanValue()) {
                if (cosmetic == null) {
                    PLAYER_COSMETICS.remove(playerName);
                } else {
                    PLAYER_COSMETICS.put(playerName, cosmetic);
                }
                KPacketSender.sendToAll(new SSyncCosmeticPacket((ImmutableMap<String, class_2960>)ImmutableMap.of((Object)playerName, (Object)cosmetic)), player.field_13995);
            }
        });
    }

    public static boolean isRenderable(class_2960 id) {
        Contributors.refreshRenderables();
        return RENDERABLES.contains(id);
    }

    public static Set<class_2960> getRenderableTiers() {
        Contributors.refreshRenderables();
        return Collections.unmodifiableSet(RENDERABLES);
    }

    private static void refreshRenderables() {
        int current = Calendar.getInstance().get(5);
        if (current != DAY) {
            DAY = current;
            RENDERABLES.clear();
            for (Map.Entry<String, ITierProvider> entry : REWARD_PROVIDERS.entrySet()) {
                String namespace = entry.getKey();
                for (String tier : entry.getValue().getRenderableTiers()) {
                    RENDERABLES.add(class_2960.method_60655((String)namespace, (String)tier));
                }
            }
        }
    }

    public static CompletableFuture<Boolean> canPlayerUseCosmetic(String playerName, class_2960 cosmetic) {
        if (cosmetic == null || cosmetic.method_12832().isEmpty()) {
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        if (!Contributors.isRenderable(cosmetic)) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        ITierProvider provider = REWARD_PROVIDERS.getOrDefault(cosmetic.method_12836().toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE);
        if (!provider.isContributor(playerName, cosmetic.method_12832())) {
            if (!Platform.isPhysicalClient()) {
                return provider.refresh().thenApply($ -> provider.isContributor(playerName, cosmetic.method_12832()));
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @Override
    protected void init(InitEvent event) {
        Contributors.registerTierProvider(new KiwiTierProvider());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (!server.method_19466(handler.field_14140.method_7334())) {
                KPacketSender.send((class_8710)new SSyncCosmeticPacket((ImmutableMap<String, class_2960>)ImmutableMap.copyOf(PLAYER_COSMETICS)), (class_1657)handler.field_14140);
            }
        });
        if (!Platform.isPhysicalClient()) {
            ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> PLAYER_COSMETICS.remove(handler.field_14140.method_7334().getName()));
        }
    }
}

