/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import snownee.kiwi.KiwiModuleContainer;
import snownee.kiwi.KiwiModules;

public abstract class KiwiBlockLoot
extends FabricBlockLootTableProvider {
    protected final class_2960 moduleId;
    private final List<class_2248> knownBlocks;
    private final Map<Class<?>, Function<class_2248, class_52.class_53>> handlers = Maps.newIdentityHashMap();
    private final Set<class_2248> added = Sets.newHashSet();
    private Function<class_2248, class_52.class_53> defaultHandler;

    protected KiwiBlockLoot(class_2960 moduleId, FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
        this.moduleId = moduleId;
        KiwiModuleContainer container = Objects.requireNonNull(KiwiModules.get(moduleId));
        this.knownBlocks = container.getRegistries(class_7924.field_41254);
    }

    protected <T extends class_2248> void handle(Class<T> clazz, Function<T, class_52.class_53> handler) {
        this.handlers.put(clazz, handler);
    }

    protected void handleDefault(Function<class_2248, class_52.class_53> handler) {
        this.defaultHandler = handler;
    }

    public void method_10379() {
        this.addTables();
        for (class_2248 block : this.knownBlocks) {
            class_52.class_53 builder;
            if (this.added.contains(block)) continue;
            this.added.add(block);
            Function<class_2248, class_52.class_53> handler = this.handlers.get(block.getClass());
            if (handler == null) {
                handler = this.defaultHandler;
            }
            if (handler == null || (builder = handler.apply(block)) == null) continue;
            this.method_45988(block, builder);
        }
    }

    protected abstract void addTables();

    public void method_45988(class_2248 block, class_52.class_53 builder) {
        super.method_45988(block, builder);
        this.added.add(block);
    }

    public List<class_2248> getKnownBlocks() {
        return this.knownBlocks;
    }

    public String method_10321() {
        return super.method_10321() + " - " + String.valueOf(this.moduleId);
    }
}

