/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.loader;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_3231;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import snownee.kiwi.Kiwi;

public final class Platform {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+).*?$");
    private static final boolean DATA_GEN = System.getProperty("fabric-api.datagen") != null;

    private Platform() {
    }

    public static boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    public static boolean isPhysicalClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static MinecraftServer getServer() {
        return Kiwi.currentServer;
    }

    public static boolean isProduction() {
        return !FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isDataGen() {
        return DATA_GEN;
    }

    public static int getVersionNumber(String id) {
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer(id).orElseThrow();
        String version = container.getMetadata().getVersion().getFriendlyString();
        Matcher matcher = VERSION_PATTERN.matcher(version);
        int result = 0;
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid version string: " + version);
        }
        for (int i = 1; i <= 3; ++i) {
            int group = Math.min(Integer.parseInt(matcher.group(i)), 99);
            result = result * 100 + group;
        }
        return result;
    }

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static class_1799 getCraftingRemainingItem(class_1799 stack) {
        return stack.getRecipeRemainder();
    }

    public static boolean isFakePlayer(class_1657 player) {
        return player instanceof FakePlayer;
    }

    public static class_2596<class_2602> defaultAddEntityPacket(class_1297 entity, class_3231 serverEntity) {
        return new class_2604(entity, serverEntity);
    }

    public static boolean isCurativeItem(class_1293 effectInstance, class_1799 stack) {
        return stack.method_31573(ConventionalItemTags.MILK_BUCKETS);
    }

    public static boolean isShearsLeftClickable(class_1799 stack) {
        return stack.method_31573(ConventionalItemTags.SHEARS_TOOLS);
    }

    public static boolean isShearsRightClickable(class_1799 stack) {
        return stack.method_31573(ConventionalItemTags.SHEARS_TOOLS);
    }

    public static class_3611 getFluidFromBucket(class_1755 item) {
        return item.field_7905;
    }

    public static class_5250 format(String s, Object ... objects) {
        try {
            return class_2561.method_43470((String)MessageFormat.format(class_1074.method_4662((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return class_2561.method_43469((String)s, (Object[])objects);
        }
    }

    public static String getTagTranslationKey(class_6862<?> tagKey) {
        return tagKey.getTranslationKey();
    }

    public static Type getPlatform() {
        return Type.Fabric;
    }

    public static Type getPlatformSeries() {
        return Type.Fabric;
    }

    public static enum Type {
        Vanilla,
        Fabric,
        Quilt,
        Forge,
        NeoForge;

    }
}

