/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneManager;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.event.WaystoneInitializedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdatedEvent;
import net.blay09.mods.waystones.api.event.WaystonesLoadedEvent;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WaystoneManagerImpl
extends class_18
implements WaystoneManager {
    private static final String DATA_NAME = "waystones";
    private static final String TAG_WAYSTONES = "Waystones";
    private static final WaystoneManagerImpl clientStorageCopy = new WaystoneManagerImpl();
    private final Map<UUID, Waystone> waystones = new HashMap<UUID, Waystone>();

    public void addWaystone(Waystone waystone) {
        this.waystones.put(waystone.getWaystoneUid(), waystone);
        this.method_80();
        Balm.getEvents().fireEvent((Object)new WaystoneInitializedEvent(waystone));
    }

    public void updateWaystone(Waystone waystone) {
        WaystoneImpl mutableWaystone = (WaystoneImpl)this.waystones.getOrDefault(waystone.getWaystoneUid(), waystone);
        mutableWaystone.setName(waystone.getName());
        mutableWaystone.setVisibility(waystone.getVisibility());
        this.waystones.put(waystone.getWaystoneUid(), mutableWaystone);
        this.method_80();
        Balm.getEvents().fireEvent((Object)new WaystoneUpdatedEvent(waystone));
    }

    public void removeWaystone(Waystone waystone) {
        this.waystones.remove(waystone.getWaystoneUid());
        this.method_80();
        Balm.getEvents().fireEvent((Object)new WaystoneRemovedEvent(waystone));
    }

    @Override
    public Optional<Waystone> getWaystoneAt(class_1922 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            return Optional.of(((WaystoneBlockEntityBase)blockEntity).getWaystone());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Waystone> getWaystoneById(UUID waystoneUid) {
        return Optional.ofNullable(this.waystones.get(waystoneUid));
    }

    @Override
    public Optional<Waystone> findWaystoneByName(String name) {
        return this.waystones.values().stream().filter(it -> it.getName().getString().equals(name)).findFirst();
    }

    @Override
    public Stream<Waystone> getWaystones() {
        return this.waystones.values().stream();
    }

    @Override
    public Stream<Waystone> getWaystonesByType(class_2960 type) {
        return this.waystones.values().stream().filter(it -> it.getWaystoneType().equals((Object)type));
    }

    @Override
    public List<Waystone> getGlobalWaystones() {
        return this.waystones.values().stream().filter(it -> it.getVisibility() == WaystoneVisibility.GLOBAL).collect(Collectors.toList());
    }

    public static WaystoneManagerImpl read(class_2487 tagCompound, class_7225.class_7874 provider) {
        WaystoneManagerImpl waystoneManager = new WaystoneManagerImpl();
        class_2499 tagList = tagCompound.method_10554(TAG_WAYSTONES, 10);
        for (class_2520 tag : tagList) {
            class_2487 compound = (class_2487)tag;
            Waystone waystone = WaystoneImpl.read(compound, provider);
            waystoneManager.waystones.put(waystone.getWaystoneUid(), waystone);
        }
        Balm.getEvents().fireEvent((Object)new WaystonesLoadedEvent(waystoneManager));
        return waystoneManager;
    }

    public class_2487 method_75(class_2487 tagCompound, class_7225.class_7874 provider) {
        class_2499 tagList = new class_2499();
        for (Waystone waystone : this.waystones.values()) {
            tagList.add((Object)WaystoneImpl.write(waystone, new class_2487(), provider));
        }
        tagCompound.method_10566(TAG_WAYSTONES, (class_2520)tagList);
        return tagCompound;
    }

    public static WaystoneManagerImpl get(@Nullable MinecraftServer server) {
        if (server != null) {
            class_3218 overworld = server.method_3847(class_1937.field_25179);
            return (WaystoneManagerImpl)Objects.requireNonNull(overworld).method_17983().method_17924(new class_18.class_8645(WaystoneManagerImpl::new, WaystoneManagerImpl::read, class_4284.field_45079), DATA_NAME);
        }
        return clientStorageCopy;
    }
}

