/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.client.gui.stats.panel.GameProfilePanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.CustomStatElement;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.GeneralStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortCustomsBy;
import io.github.thecsdev.betterstats.api.util.formatters.StatValueFormatter;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUGeneralStat;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.hud.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.gui.screen.hud.entry.StatsHudGeneralEntry;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatsTabPanel;
import io.github.thecsdev.betterstats.client.gui.stats.tabs.BSStatsTab;
import io.github.thecsdev.betterstats.mixin.hooks.AccessorStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TFillColorElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.hooks.world.biome.source.BiomeAccessHooks;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3446;
import net.minecraft.class_4543;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class GeneralStatsTab
extends BSStatsTab<SUGeneralStat> {
    @Override
    public final class_2561 getName() {
        return TextUtils.translatable((String)"stat.generalButton", (Object[])new Object[0]);
    }

    @Override
    public final void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        int sp = panel.getScrollPadding();
        IStatsProvider statsProvider = initContext.getStatsProvider();
        StatFilterSettings filterSettings = initContext.getFilterSettings();
        FilterGroupBy groupBy = (FilterGroupBy)((Object)filterSettings.getPropertyOrDefault(StatsTabUtils.FILTER_ID_GROUP, (Object)FilterGroupBy.DEFAULT));
        FilterSortCustomsBy sortBy = (FilterSortCustomsBy)((Object)filterSettings.getProperty(StatsTabUtils.FILTER_ID_SORT_CUSTOMS, (Object)FilterSortCustomsBy.DEFAULT));
        StatValueFormatter timeFormat = (StatValueFormatter)filterSettings.getPropertyOrDefault(StatsTabUtils.FILTER_ID_FORMAT_TIME, StatValueFormatter.TIME);
        StatValueFormatter distanceFormat = (StatValueFormatter)filterSettings.getPropertyOrDefault(StatsTabUtils.FILTER_ID_FORMAT_DISTANCE, StatValueFormatter.DISTANCE);
        if (!BetterStats.getInstance().getConfig().hidePlayerInfo) {
            GameProfilePanel panel_gp = new GameProfilePanel(sp, sp, panel.getWidth() - sp * 2, statsProvider);
            panel.addChild((TElement)panel_gp, true);
        }
        if (BetterStatsConfig.DEBUG_MODE && statsProvider instanceof LocalPlayerStatsProvider) {
            GeneralStatsTab.initDebugInfo(panel);
        }
        if (BetterStatsConfig.DEBUG_MODE) {
            StatsTabUtils.initGroupLabel(panel, (class_2561)TextUtils.translatable((String)"entity.minecraft.player", (Object[])new Object[0])).setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        }
        Map statGroups = groupBy == FilterGroupBy.DEFAULT ? this.getDefaultGroupFilter().apply(SUGeneralStat.getGeneralStats(statsProvider, this.getPredicate(filterSettings)), new SUGeneralStat[0]) : groupBy.apply(SUGeneralStat.getGeneralStats(statsProvider, this.getPredicate(filterSettings)), new SUGeneralStat[0]);
        statGroups.entrySet().forEach(e -> sortBy.sortGeneralStats((List)e.getValue()));
        if (statGroups.size() > 0) {
            for (Map.Entry statGroup : statGroups.entrySet()) {
                class_2561 group = (class_2561)statGroup.getKey();
                StatsTabUtils.initGroupLabel(panel, (class_2561)(group != null ? group : TextUtils.literal((String)"*")));
                this.initStats(panel, (Collection)statGroup.getValue(), widget -> {
                    this.processWidget((GeneralStatWidget)((Object)widget));
                    class_3446 statFormat = ((AccessorStat)((SUGeneralStat)widget.getStat()).getGeneralStat()).getFormatter();
                    if (statFormat == class_3446.field_16979) {
                        widget.setFormatter(timeFormat);
                    } else if (statFormat == class_3446.field_16977) {
                        widget.setFormatter(distanceFormat);
                    }
                });
            }
        } else {
            Rectangle n1 = UILayout.nextChildVerticalRect((TParentElement)panel);
            TFillColorElement fill = new TFillColorElement(n1.x, n1.y + 3, n1.width, GeneralStatWidget.HEIGHT);
            fill.setColor(0x50000000);
            panel.addChild((TElement)fill, false);
            TLabelElement lbl_noStats = new TLabelElement(0, 0, fill.getWidth(), fill.getHeight());
            lbl_noStats.setText(StatsTabPanel.TXT_NO_STATS_YET);
            lbl_noStats.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
            fill.addChild((TElement)lbl_noStats, true);
        }
    }

    @Override
    protected final void initExtraFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initGroupByFilter(initContext);
        StatsTabUtils.initSortCustomsByFilter(initContext);
        StatsTabUtils.initTimeFormatFilter(initContext);
        StatsTabUtils.initDistanceFormatFilter(initContext);
    }

    @Virtual
    protected FilterGroupBy getDefaultGroupFilter() {
        return FilterGroupBy.DEFAULT;
    }

    protected final void initStats(TPanelElement panel, Collection<SUGeneralStat> stats, Consumer<GeneralStatWidget> processWidget) {
        for (SUGeneralStat stat : stats) {
            Rectangle n1 = UILayout.nextChildVerticalRect((TParentElement)panel);
            GeneralStatWidget statWidget = new GeneralStatWidget(n1.x, n1.y + 3, n1.width, stat);
            panel.addChild((TElement)statWidget, false);
            if (processWidget == null) continue;
            processWidget.accept(statWidget);
        }
    }

    @Virtual
    protected void processWidget(GeneralStatWidget widget) {
        widget.eContextMenu.register((__, cMenu) -> {
            if (!(((SUGeneralStat)widget.getStat()).getStatsProvider() instanceof LocalPlayerStatsProvider)) {
                return;
            }
            cMenu.addButton((class_2561)BST.hud_pinStat(), ___ -> {
                BetterStatsHudScreen hud = BetterStatsHudScreen.getInstance();
                hud.setParentScreen(BetterStatsClient.MC_CLIENT.field_1755);
                hud.addEntry(new StatsHudGeneralEntry((SUGeneralStat)widget.getStat(), widget.getFormatter()));
                BetterStatsClient.MC_CLIENT.method_1507(hud.getAsScreen());
            });
            cMenu.addButton((class_2561)TextUtils.translatable((String)"mco.selectServer.close", (Object[])new Object[0]), ___ -> {});
        });
    }

    protected static final void initDebugInfo(TPanelElement panel) {
        StatsTabUtils.initGroupLabel(panel, (class_2561)TextUtils.translatable((String)"createWorld.tab.world.title", (Object[])new Object[0])).setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        Rectangle n1 = UILayout.nextChildVerticalRect((TParentElement)panel);
        TFillColorElement wsp = new TFillColorElement(n1.x, n1.y, n1.width, CustomStatElement.HEIGHT * 2 + 3);
        wsp.setColor(0x50000000);
        panel.addChild((TElement)wsp, false);
        class_638 world = BetterStatsClient.MC_CLIENT.field_1687;
        CustomStatElement ws1 = new CustomStatElement(wsp.getX(), wsp.getY(), wsp.getWidth(), (class_2561)TextUtils.translatable((String)"selectWorld.enterName", (Object[])new Object[0]), (class_2561)TextUtils.literal((String)Objects.toString(world != null ? world.method_27983().method_29177() : "-")));
        CustomStatElement ws2 = new CustomStatElement(wsp.getX(), wsp.getEndY() - CustomStatElement.HEIGHT, wsp.getWidth(), (class_2561)BST.sTab_hashedSeed(), (class_2561)TextUtils.literal((String)Objects.toString(BiomeAccessHooks.getBiomeAccessSeed((class_4543)world.method_22385()))));
        wsp.addChild((TElement)ws1, false);
        wsp.addChild((TElement)ws2, false);
    }
}

