/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.new_slab_variants.core.common.registry;

import java.util.function.Supplier;
import neoforge.com.cursee.new_slab_variants.core.common.registry.ModBlockEntityTypesForge;
import neoforge.com.cursee.new_slab_variants.core.common.registry.ModBlocksForge;
import neoforge.com.cursee.new_slab_variants.core.common.registry.ModEntityTypesForge;
import neoforge.com.cursee.new_slab_variants.core.common.registry.ModItemsForge;
import neoforge.com.cursee.new_slab_variants.core.common.registry.ModTabsForge;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RegistryForge {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"new_slab_variants");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"new_slab_variants");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.key(), (String)"new_slab_variants");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"new_slab_variants");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"new_slab_variants");

    public static void register(IEventBus modEventBus) {
        ModBlocksForge.register();
        ModItemsForge.register();
        ModTabsForge.register();
        ModBlockEntityTypesForge.register();
        ModEntityTypesForge.register();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        ModTabsForge.slabs.addAll(ITEMS.getEntries());
        TABS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
    }

    protected static <T extends Block> DeferredHolder<Block, T> registerBlock(String blockID, Supplier<T> blockSupplier) {
        return BLOCKS.register(blockID, blockSupplier);
    }

    protected static <T extends Item> DeferredHolder<Item, T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    protected static <T extends Block> DeferredHolder<Block, T> registerBlockAndBlockItem(String name, Supplier<T> block) {
        DeferredHolder toReturn = RegistryForge.registerBlock(name, block);
        RegistryForge.registerItem(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    protected static <T extends CreativeModeTab> DeferredHolder<CreativeModeTab, T> registerCreativeModeTab(String tabID, Supplier<T> tab) {
        return TABS.register(tabID, tab);
    }

    protected static <T extends BlockEntityType<?>> DeferredHolder<BlockEntityType<?>, T> registerBlockEntityType(String entityTypeID, Supplier<T> entityType) {
        return BLOCK_ENTITY_TYPES.register(entityTypeID, entityType);
    }

    protected static <T extends EntityType<?>> DeferredHolder<EntityType<?>, T> registerEntityType(String entityTypeID, Supplier<T> entityType) {
        return ENTITY_TYPES.register(entityTypeID, entityType);
    }
}

