/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mrcrayfish.framework.api.menu.IMenuData;
import com.mrcrayfish.framework.api.registry.RegistryContainer;
import com.mrcrayfish.framework.api.registry.RegistryEntry;
import com.mrcrayfish.framework.platform.services.IRegistrationHelper;
import com.mrcrayfish.framework.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.function.TriFunction;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;

public class FabricRegistrationHelper
implements IRegistrationHelper {
    @Override
    public List<RegistryEntry<?>> getAllRegistryEntries() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(this.getScanPackages()).addScanners(new Scanner[]{Scanners.TypesAnnotated}));
        Set containerClass = reflections.getTypesAnnotatedWith(RegistryContainer.class);
        return containerClass.stream().map(ReflectionUtils::findRegistryEntriesInClass).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String[] getScanPackages() {
        return (String[])FabricLoader.getInstance().getAllMods().stream().map(this::getScanPackages).flatMap(Collection::stream).toArray(String[]::new);
    }

    private List<String> getScanPackages(ModContainer container) {
        CustomValue.CvObject frameworkObj;
        CustomValue containersValue;
        CustomValue value = container.getMetadata().getCustomValue("framework");
        if (value != null && value.getType() == CustomValue.CvType.OBJECT && (containersValue = (frameworkObj = value.getAsObject()).get("containers")) != null) {
            if (containersValue.getType() == CustomValue.CvType.ARRAY) {
                ArrayList<String> packages = new ArrayList<String>();
                CustomValue.CvArray packagesArray = containersValue.getAsArray();
                packagesArray.forEach(packageValue -> {
                    if (packageValue.getType() == CustomValue.CvType.STRING) {
                        packages.add(packageValue.getAsString());
                    }
                });
                return packages;
            }
            if (containersValue.getType() == CustomValue.CvType.STRING) {
                return Collections.singletonList(containersValue.getAsString());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> function, Supplier<class_2248[]> validBlocksSupplier) {
        return class_2591.class_2592.method_20528(function::apply, (class_2248[])validBlocksSupplier.get()).method_11034(null);
    }

    @Override
    public <T extends class_1703> class_3917<T> createMenuType(BiFunction<Integer, class_1661, T> function) {
        return new class_3917(function::apply, class_7701.field_40183);
    }

    @Override
    public <T extends class_1703, D extends IMenuData<D>> class_3917<T> createMenuTypeWithData(class_9139<class_9129, D> codec, TriFunction<Integer, class_1661, D, T> function) {
        return new ExtendedScreenHandlerType((arg_0, arg_1, arg_2) -> function.apply(arg_0, arg_1, arg_2), codec);
    }

    @Override
    public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I createArgumentTypeInfo(Class<A> argumentTypeClass, Supplier<I> supplier) {
        class_2314 instance = (class_2314)supplier.get();
        class_2316.field_10921.put(argumentTypeClass, instance);
        return (I)instance;
    }

    @Override
    public class_1761.class_7913 createCreativeModeTabBuilder() {
        return FabricItemGroup.builder();
    }
}

