/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass.test;

import java.time.Duration;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_155;
import net.minecraft.class_442;
import net.minecraft.class_525;
import net.minecraft.class_526;
import net.minecraft.class_8032;
import net.wurstclient.glass.test.WiModsTestHelper;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class MoGlassTestClient
implements ClientModInitializer {
    public void onInitializeClient() {
        if (System.getProperty("mo_glass.e2eTest") == null) {
            return;
        }
        Thread.ofVirtual().name("Mo Glass End-to-End Test").uncaughtExceptionHandler((t, e) -> {
            e.printStackTrace();
            System.exit(1);
        }).start(this::runTests);
    }

    private void runTests() {
        System.out.println("Starting Mo Glass End-to-End Test");
        WiModsTestHelper.waitForResourceLoading();
        if (WiModsTestHelper.submitAndGet(mc -> mc.field_1690.field_41785).booleanValue()) {
            System.out.println("Onboarding is enabled. Waiting for it");
            WiModsTestHelper.waitForScreen(class_8032.class);
            System.out.println("Reached onboarding screen");
            WiModsTestHelper.clickButton("gui.continue");
        }
        WiModsTestHelper.waitForScreen(class_442.class);
        WiModsTestHelper.waitForTitleScreenFade();
        System.out.println("Reached title screen");
        WiModsTestHelper.takeScreenshot("title_screen", Duration.ZERO);
        System.out.println("Clicking singleplayer button");
        WiModsTestHelper.clickButton("menu.singleplayer");
        if (WiModsTestHelper.submitAndGet(mc -> !mc.method_1586().method_235().method_43421()).booleanValue()) {
            System.out.println("World list is not empty. Waiting for it");
            WiModsTestHelper.waitForScreen(class_526.class);
            System.out.println("Reached select world screen");
            WiModsTestHelper.takeScreenshot("select_world_screen");
            WiModsTestHelper.clickButton("selectWorld.create");
        }
        WiModsTestHelper.waitForScreen(class_525.class);
        System.out.println("Reached create world screen");
        WiModsTestHelper.setTextFieldText(0, "E2E Test " + class_155.method_16673().method_48019());
        WiModsTestHelper.clickButton("selectWorld.gameMode");
        WiModsTestHelper.clickButton("selectWorld.gameMode");
        WiModsTestHelper.takeScreenshot("create_world_screen");
        System.out.println("Creating test world");
        WiModsTestHelper.clickButton("selectWorld.create");
        WiModsTestHelper.waitForWorldLoad();
        WiModsTestHelper.dismissTutorialToasts();
        WiModsTestHelper.waitForWorldTicks(200);
        WiModsTestHelper.runChatCommand("seed");
        System.out.println("Reached singleplayer world");
        WiModsTestHelper.takeScreenshot("in_game", Duration.ZERO);
        WiModsTestHelper.clearChat();
        System.out.println("Opening debug menu");
        WiModsTestHelper.toggleDebugHud();
        WiModsTestHelper.takeScreenshot("debug_menu");
        System.out.println("Closing debug menu");
        WiModsTestHelper.toggleDebugHud();
        System.out.println("Checking for broken mixins");
        MixinEnvironment.getCurrentEnvironment().audit();
        System.out.println("Opening inventory");
        WiModsTestHelper.openInventory();
        WiModsTestHelper.takeScreenshot("inventory");
        System.out.println("Closing inventory");
        WiModsTestHelper.closeScreen();
        WiModsTestHelper.runChatCommand("fill ~-5 ~-1 ~-5 ~5 ~-1 ~5 stone");
        WiModsTestHelper.runChatCommand("fill ~-5 ~ ~-5 ~5 ~30 ~5 air");
        WiModsTestHelper.runChatCommand("clear");
        WiModsTestHelper.clearChat();
        System.out.println("Opening game menu");
        WiModsTestHelper.openGameMenu();
        WiModsTestHelper.takeScreenshot("game_menu");
        System.out.println("Returning to title screen");
        WiModsTestHelper.clickButton("menu.returnToMenu");
        WiModsTestHelper.waitForScreen(class_442.class);
        System.out.println("Stopping the game");
        WiModsTestHelper.clickButton("menu.quit");
    }
}

