/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2482;
import net.minecraft.class_2488;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SRMSnowLayerBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.convert.BlockConverter;
import snownee.snow.mixin.BlockBehaviourAccess;
import snownee.snow.network.SSnowLandEffectPacket;
import snownee.snow.util.CommonProxy;

public final class Hooks {
    private static final MapDecoder<class_2960> BLOCK_ENTITY_ID = class_2960.field_25139.fieldOf("id");

    private Hooks() {
    }

    public static void placeFeatureExtra(class_1959 biome, class_5281 level, class_2338 pos, class_2338 belowPos) {
        if (!(SnowCommonConfig.replaceWorldFeature && SnowCommonConfig.placeSnowOnBlockNaturally && SnowCommonConfig.canPlaceSnowInBlock())) {
            return;
        }
        if (biome.method_39927(pos) || level.method_8314(class_1944.field_9282, pos) >= 10 || !Hooks.canSnowSurvive((class_4538)level, pos)) {
            return;
        }
        class_2680 blockstate = level.method_8320(pos);
        if (Hooks.convert((class_1936)level, pos, blockstate, 1, 2, true) && (blockstate = level.method_8320(belowPos)).method_28498((class_2769)class_2741.field_12512)) {
            level.method_8652(belowPos, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Deprecated
    public static boolean canSnowSurvive(class_2680 blockState, class_1922 level, class_2338 pos) {
        try {
            return class_2246.field_10477.method_9564().method_26184((class_4538)level, pos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canSnowSurvive(class_4538 level, class_2338 pos) {
        return class_2246.field_10477.method_9564().method_26184(level, pos);
    }

    public static boolean canContainState(class_2680 blockState) {
        return CoreModule.CONVERTERS.of(blockState) != null;
    }

    public static boolean convert(class_1936 level, class_2338 pos, class_2680 blockState, int layers, int flags, boolean canConvert) {
        return Hooks.convert(level, pos, blockState, layers, flags, canConvert, true);
    }

    public static boolean convert(class_1936 level, class_2338 pos, class_2680 blockState, int layers, int flags, boolean canConvert, boolean checkSurvive) {
        class_2680 newState = Hooks.getSnowBlockFor(level, pos, blockState, layers, canConvert);
        if (newState == null) {
            return false;
        }
        if (checkSurvive && !newState.method_26184((class_4538)level, pos)) {
            return false;
        }
        level.method_8652(pos, newState, flags);
        SRMSnowLayerBlock.setContainedState(level, pos, blockState);
        Hooks.processFancyOverlay(level, pos, class_1799.field_8037);
        return true;
    }

    public static void processFancyOverlay(class_1936 level, class_2338 pos, class_1799 itemStack) {
        SnowBlockEntity be;
        block5: {
            block4: {
                class_2586 class_25862;
                if (itemStack.method_57826(class_9334.field_49611) || !((class_25862 = level.method_8321(pos)) instanceof SnowBlockEntity)) break block4;
                be = (SnowBlockEntity)class_25862;
                if (!be.options.renderOverlay) break block5;
            }
            return;
        }
        if (SnowCommonConfig.fancySnowOnUpperSlab && level.method_8320(pos.method_10074()).method_26204() instanceof class_2482) {
            be.options.renderOverlay = true;
            be.method_5431();
        }
    }

    @Nullable
    public static class_2680 getSnowBlockFor(class_1936 level, class_2338 pos, class_2680 blockState, int layers, boolean canConvert) {
        if (SnowCommonConfig.restoreOriginalBlocks || blockState.method_31709() || !blockState.method_26227().method_15769() || blockState.method_26164(CoreModule.NOT_CONTAINABLES)) {
            return null;
        }
        if (!(blockState.method_26215() || canConvert && SnowCommonConfig.canPlaceSnowInBlock())) {
            return null;
        }
        BlockConverter converter = CoreModule.CONVERTERS.of(blockState);
        if (converter == null) {
            return null;
        }
        if ((blockState = converter.convert(level, pos, blockState, layers)).method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
            blockState = (class_2680)blockState.method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            class_2338 posDown = pos.method_10074();
            class_2680 stateDown = level.method_8320(posDown);
            blockState = blockState.method_26191(class_2350.field_11033, stateDown, level, pos, posDown);
        } else if (blockState.method_28498((class_2769)class_2488.field_11518)) {
            blockState = (class_2680)blockState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers));
        }
        return blockState;
    }

    public static <T extends Comparable<T>> boolean hasAllProperties(class_2680 oldState, class_2680 newState) {
        for (Map.Entry entry : newState.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            if (property == SnowVariant.OPTIONAL_LAYERS || oldState.method_28498(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> class_2680 copyProperties(class_2680 oldState, class_2680 newState) {
        for (Map.Entry entry : oldState.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            newState = (class_2680)newState.method_47968(property, (Comparable)property.method_11902().cast(entry.getValue()));
        }
        return newState;
    }

    public static boolean placeLayersOn(class_1937 level, class_2338 pos, int layers, boolean fallingEffect, class_1750 useContext, boolean playSound, boolean canConvert) {
        layers = class_3532.method_15340((int)layers, (int)1, (int)8);
        class_2680 state = level.method_8320(pos);
        int originLayers = 0;
        if (state.method_28498((class_2769)class_2488.field_11518)) {
            originLayers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(class_3532.method_15340((int)(originLayers + layers), (int)1, (int)8))));
        } else if (state.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
            originLayers = (Integer)state.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS);
            if (originLayers == 0 && !Hooks.canSnowSurvive((class_4538)level, pos)) {
                return false;
            }
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(class_3532.method_15340((int)(originLayers + layers), (int)1, (int)8))));
        } else if (state.method_26184((class_4538)level, pos) && (canConvert || state.method_26166(useContext))) {
            if (!Hooks.convert((class_1936)level, pos, state, layers, 3, canConvert)) {
                return false;
            }
        } else {
            return false;
        }
        class_2680 newState = level.method_8320(pos);
        class_2248.method_9582((class_2680)state, (class_2680)newState, (class_1936)level, (class_2338)pos);
        if (fallingEffect) {
            new SSnowLandEffectPacket(pos, (byte)originLayers, (byte)layers).sendToAround((class_3218)level);
        } else if (playSound) {
            class_2498 soundtype = ((BlockBehaviourAccess)class_2246.field_10477).callGetSoundType(class_2246.field_10477.method_9564());
            level.method_8396(null, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.method_10084();
            newState = level.method_8320(pos);
            useContext = class_1750.method_16355((class_1750)useContext, (class_2338)pos, (class_2350)class_2350.field_11036);
            if (Hooks.canSnowSurvive((class_4538)level, pos) && newState.method_26166(useContext)) {
                Hooks.placeLayersOn(level, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound, canConvert);
            }
        }
        return true;
    }

    public static boolean canFallThrough(class_2680 state, class_1937 level, class_2338 pos) {
        SnowVariant snow;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof SnowVariant && (snow = (SnowVariant)class_22482).srm$maxLayers(state, level, pos) == 8 && snow.srm$layers(state, (class_1922)level, pos) < 8) {
            return true;
        }
        return class_2346.method_10128((class_2680)state) && state.method_26220((class_1922)level, pos).method_1110();
    }

    public static void randomTick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        Hooks.randomTick(state, level, pos, random, 0.125f);
    }

    public static void randomTick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random, float chance) {
        boolean melt;
        if (chance != 1.0f && random.method_43057() > chance) {
            return;
        }
        class_6880 biome = level.method_23753(pos);
        SnowVariant snow = (SnowVariant)state.method_26204();
        int layers = snow.srm$layers(state, (class_1922)level, pos);
        boolean meltByTemperature = false;
        boolean meltByBrightness = false;
        if (!SnowCommonConfig.snowNeverMelt) {
            if (layers == 8) {
                SnowVariant s;
                class_2338 above = pos.method_10084();
                class_2680 upState = level.method_8320(above);
                class_2248 class_22482 = upState.method_26204();
                if (class_22482 instanceof SnowVariant && (s = (SnowVariant)class_22482).srm$layers(upState, (class_1922)level, above) > 0) {
                    return;
                }
                meltByBrightness = level.method_8314(class_1944.field_9282, above) >= SnowCommonConfig.snowPersistMaxLightLevel;
            } else {
                meltByBrightness = level.method_8314(class_1944.field_9282, pos) > SnowCommonConfig.snowPersistMaxLightLevel;
            }
            meltByTemperature = CommonProxy.shouldMelt((class_1937)level, pos, (class_6880<class_1959>)biome, layers);
        }
        boolean bl = melt = meltByTemperature || meltByBrightness;
        if (!melt && SnowCommonConfig.accumulationWinterOnly && !CommonProxy.isWinter((class_1937)level, pos, (class_6880<class_1959>)biome)) {
            return;
        }
        boolean accumulate = false;
        if (layers < SnowCommonConfig.snowAccumulationMaxLayers && !meltByBrightness && level.method_8419() && CommonProxy.coldEnoughToSnow((class_4538)level, pos, (class_6880<class_1959>)biome) && level.method_8598(class_2902.class_2903.field_13197, pos).method_10264() == pos.method_10264()) {
            accumulate = CommonProxy.snowAccumulationNow((class_1937)level);
        }
        if (accumulate) {
            if (!level.method_8320(pos.method_10074()).method_26164(CoreModule.CANNOT_ACCUMULATE_ON)) {
                Hooks.accumulate(level, pos, state, (w, p) -> {
                    if (SnowCommonConfig.snowAccumulationMaxLayers < 9 && w.method_8320(p.method_10074()).method_26204() instanceof class_2488) {
                        return false;
                    }
                    if (SnowCommonConfig.snowSpawnMaxLightLevel < 15 && w.method_8314(class_1944.field_9282, p) > SnowCommonConfig.snowSpawnMaxLightLevel) {
                        return false;
                    }
                    return CommonProxy.coldEnoughToSnow((class_4538)w, p, (class_6880<class_1959>)w.method_23753(p));
                }, true);
            }
        } else if (melt) {
            Hooks.accumulate(level, pos, state, (w, p) -> !(w.method_8320(p.method_10084()).method_26204() instanceof class_2488), false);
        }
    }

    private static void accumulate(class_3218 level, class_2338 centerPos, class_2680 centerState, BiPredicate<class_1936, class_2338> filter, boolean accumulate) {
        if (!SnowCommonConfig.smoothAccumulation) {
            Hooks.accumulateSingle(level, centerPos, centerState, accumulate);
            return;
        }
        SnowVariant centerSnowVariant = (SnowVariant)centerState.method_26204();
        int i = centerSnowVariant.srm$layers(centerState, (class_1922)level, centerPos);
        class_2338.class_2339 pos = centerPos.method_25503();
        for (int j = 0; j < 8; ++j) {
            int l;
            int k = j / 2;
            class_2350 direction = class_2350.method_10139((int)k);
            pos.method_25505((class_2382)centerPos, direction);
            if (j % 2 == 1) {
                pos.method_10098(direction);
            }
            if (!level.method_8477((class_2338)pos) || !filter.test((class_1936)level, (class_2338)pos)) continue;
            class_2680 state = level.method_8320((class_2338)pos);
            class_2338 height = level.method_8598(class_2902.class_2903.field_13197, (class_2338)pos);
            if (height.method_10264() != pos.method_10264() && (height.method_10264() != pos.method_10264() + 1 || !(state.method_26204() instanceof SnowVariant)) || !Hooks.canSnowSurvive((class_4538)level, (class_2338)pos)) continue;
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof SnowVariant) {
                SnowVariant snowVariant = (SnowVariant)class_22482;
                l = snowVariant.srm$layers(state, (class_1922)level, (class_2338)pos);
                if (accumulate) {
                    if (l >= snowVariant.srm$maxLayers(state, (class_1937)level, (class_2338)pos) || level.method_8320((class_2338)pos.method_10098(class_2350.field_11033)).method_26164(CoreModule.CANNOT_ACCUMULATE_ON)) continue;
                    pos.method_10098(class_2350.field_11036);
                }
            } else {
                if (accumulate && !SnowCommonConfig.canPlaceSnowInBlock() && !state.method_26215()) continue;
                l = 0;
            }
            if (!(accumulate ? i > l : i < l)) continue;
            Hooks.accumulateSingle(level, (class_2338)pos, state, accumulate);
            return;
        }
        Hooks.accumulateSingle(level, centerPos, centerState, accumulate);
    }

    private static void accumulateSingle(class_3218 level, class_2338 pos, class_2680 state, boolean accumulate) {
        if (accumulate) {
            Hooks.placeLayersOn((class_1937)level, pos, 1, false, (class_1750)new class_2968((class_1937)level, pos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033), false, SnowCommonConfig.placeSnowOnBlockNaturally);
        } else {
            SnowVariant snowVariant = (SnowVariant)state.method_26204();
            level.method_8501(pos, snowVariant.srm$decreaseLayer(state, (class_1937)level, pos, false));
        }
    }

    public static boolean isSnowySetting(class_2680 blockState) {
        if (!blockState.method_26164(CoreModule.SNOWY_SETTING)) {
            return false;
        }
        if (blockState.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
            return (Integer)blockState.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS) != 0;
        }
        return true;
    }

    public static boolean canBeReplaced(class_2680 blockState, class_1750 context) {
        int i;
        boolean opt = false;
        if (blockState.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
            i = (Integer)blockState.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS);
            opt = true;
        } else if (blockState.method_28498((class_2769)class_2488.field_11518)) {
            i = (Integer)blockState.method_11654((class_2769)class_2488.field_11518);
        } else {
            throw new IllegalStateException("Invalid block state: " + String.valueOf(blockState));
        }
        if (i == 8) {
            return false;
        }
        if (!context.method_8041().method_31574(class_1802.field_8749)) {
            if (!((SnowVariant)blockState.method_26204()).srm$getRaw(blockState, (class_1922)context.method_8045(), context.method_8037()).method_26215()) {
                return false;
            }
            return SnowCommonConfig.snowAlwaysReplaceable || i == 1;
        }
        if (i == 0) {
            return Hooks.canSnowSurvive((class_4538)context.method_8045(), context.method_8037());
        }
        return opt || context.method_7717() || context.method_8038() == class_2350.field_11036;
    }

    public static class_2680 getStateForPlacement(class_2248 block, class_1750 context, @Nullable class_2680 originalState) {
        if (SnowCommonConfig.restoreOriginalBlocks) {
            return originalState;
        }
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        if (block == class_2246.field_10477) {
            class_2680 stateBelow;
            class_2680 state = level.method_8320(pos);
            if (state.method_28498((class_2769)class_2488.field_11518)) {
                int i = (Integer)state.method_11654((class_2769)class_2488.field_11518);
                return (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
            }
            if (state.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
                int i = (Integer)state.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS);
                return (class_2680)state.method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
            }
            if (SnowCommonConfig.fancySnowOnUpperSlab && (stateBelow = level.method_8320(pos.method_10074())).method_26204() instanceof class_2482) {
                return CoreModule.SNOW_BLOCK.defaultBlockState();
            }
        }
        class_9279 blockEntityData = (class_9279)context.method_8041().method_57824(class_9334.field_49611);
        if (originalState != null && blockEntityData != null) {
            class_2960 id = blockEntityData.method_57446(BLOCK_ENTITY_ID).result().orElse(null);
            if (originalState.method_26184((class_4538)level, pos) && (CoreModule.TILE.key().equals((Object)id) || CoreModule.TEXTURE_TILE.key().equals((Object)id))) {
                return Hooks.getSnowBlockFor((class_1936)level, pos, (class_2680)originalState.method_47968((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 1, true);
            }
        }
        return originalState;
    }

    public static boolean canPlaceAt(class_1937 level, class_2338 pos) {
        class_2680 snowBlock = Hooks.getSnowBlockFor((class_1936)level, pos, level.method_8320(pos), 1, true);
        return snowBlock != null && snowBlock.method_26184((class_4538)level, pos);
    }

    public static boolean useSnowWithItem(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 hitResult, SnowVariant snowVariant) {
        class_2248 block = class_2248.method_9503((class_1792)itemStack.method_7909());
        if (block == class_2246.field_10124 || !snowVariant.srm$getRaw(blockState, (class_1922)level, pos).method_26215()) {
            return false;
        }
        class_1750 context = new class_1750(player, interactionHand, itemStack, hitResult);
        if (!context.method_7717()) {
            return false;
        }
        class_2680 state2 = block.method_9605(context);
        if (state2 == null || !Hooks.canContainState(state2) || !state2.method_26184((class_4538)level, pos)) {
            return false;
        }
        if (!level.field_9236) {
            SnowBlockEntity be;
            class_2586 class_25862;
            int i = (Integer)blockState.method_11654((class_2769)class_2488.field_11518);
            boolean hasOverlay = false;
            if (i != 0 && (class_25862 = level.method_8321(pos)) instanceof SnowBlockEntity) {
                be = (SnowBlockEntity)class_25862;
                hasOverlay = be.options.renderOverlay;
            }
            level.method_8652(pos, state2, 48);
            block.method_9567(level, pos, state2, (class_1309)player, context.method_8041());
            if (Hooks.placeLayersOn(level, pos, i, false, context, true, true)) {
                if (!player.method_7337()) {
                    context.method_8041().method_7934(1);
                }
                if (hasOverlay && (class_25862 = level.method_8321(pos)) instanceof SnowBlockEntity) {
                    be = (SnowBlockEntity)class_25862;
                    be.options.renderOverlay = true;
                }
            }
        }
        return true;
    }

    public static boolean isFallable(class_2680 blockState) {
        return SnowCommonConfig.snowGravity && (blockState.method_27852(class_2246.field_10477) || blockState.method_26164(CoreModule.SNOW_TAG));
    }

    public static void restoreOriginalBlocks(class_2818 chunk) {
        class_1937 level = chunk.method_12200();
        if (!SnowCommonConfig.restoreOriginalBlocks || level.field_9236 || level.method_8503() == null || chunk.method_12214().isEmpty()) {
            return;
        }
        ArrayList blockEntities = Lists.newArrayList();
        for (class_2586 be : chunk.method_12214().values()) {
            class_2680 blockState = be.method_11010();
            if (!(blockState.method_26204() instanceof SnowVariant)) continue;
            blockEntities.add(be);
        }
        if (blockEntities.isEmpty()) {
            return;
        }
        level.method_8503().method_18858((Runnable)new class_3738(0, () -> {
            for (class_2586 be : blockEntities) {
                class_1937 level1 = be.method_10997();
                if (be.method_11015() || level1 == null) continue;
                class_2680 blockState = be.method_11010();
                class_2338 pos = be.method_11016();
                class_2680 raw = ((SnowVariant)blockState.method_26204()).srm$getRaw(blockState, (class_1922)level1, pos);
                if (raw.method_26215()) {
                    raw = ((SnowVariant)blockState.method_26204()).srm$getSnowState(blockState, (class_1922)level1, pos);
                }
                level1.method_8652(pos, raw, 20);
                class_2338 below = pos.method_10074();
                class_2680 belowState = level1.method_8320(below);
                if (!belowState.method_28498((class_2769)class_2741.field_12512) || !((Boolean)belowState.method_11654((class_2769)class_2741.field_12512)).booleanValue()) continue;
                level1.method_8652(below, (class_2680)belowState.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(false)), 20);
            }
        }));
    }
}

