/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_2510;
import net.minecraft.class_2521;
import net.minecraft.class_2526;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.SnowWallBlock;

@NotNullByDefault
public class ShapeCaches {
    public static final Cache<Object, class_265> VISUAL = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<Object, class_265> COLLIDER = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<Object, class_265> OUTLINE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public static class_265 get(Cache<Object, class_265> cache, class_2680 blockState, Function<class_2680, class_265> shapeFunc) {
        return ShapeCaches.get(cache, blockState, shapeFunc, class_259::method_1084);
    }

    public static class_265 get(Cache<Object, class_265> cache, class_2680 blockState, Function<class_2680, class_265> shapeFunc, BinaryOperator<class_265> shapeMerger) {
        blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        class_265 shape = (class_265)cache.getIfPresent((Object)(blockState = (class_2680)blockState.method_47968((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12617)));
        if (shape == null) {
            SnowVariant snowVariant = (SnowVariant)blockState.method_26204();
            int layers = snowVariant.srm$layers(blockState, (class_1922)class_2682.field_12294, class_2338.field_10980);
            class_2680 key = blockState;
            if (layers != 1 && blockState.method_26204() instanceof SnowWallBlock) {
                blockState = (class_2680)blockState.method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(1));
            }
            shape = shapeFunc.apply(blockState);
            if (layers != 0 && blockState.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
                class_2680 snowState = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers));
                class_265 snowShape = cache == VISUAL ? snowState.method_26201((class_1922)class_2682.field_12294, class_2338.field_10980) : (cache == COLLIDER ? snowState.method_26194((class_1922)class_2682.field_12294, class_2338.field_10980, class_3726.method_16194()) : snowState.method_26172((class_1922)class_2682.field_12294, class_2338.field_10980, class_3726.method_16194()));
                shape = (class_265)shapeMerger.apply(shape, snowShape);
            }
            cache.put((Object)key, (Object)shape);
        }
        return shape;
    }

    public static class_265 get(Cache<Object, class_265> cache, class_2680 blockState, class_1922 level, class_2338 pos, Callable<? extends class_265> loader) {
        blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        try {
            Key key;
            SnowVariant snowVariant = (SnowVariant)blockState.method_26204();
            int layers = snowVariant.srm$layers(blockState, level, pos);
            if (blockState.method_26164(CoreModule.SNOW_TAG)) {
                class_2680 raw = snowVariant.srm$getRaw(blockState, level, pos);
                Class<?> clazz = raw.method_26204().getClass();
                if (clazz != class_2526.class && clazz != class_2521.class) {
                    return loader.call();
                }
                key = new Key(raw, layers);
            } else {
                key = new Key(blockState, layers);
            }
            return (class_265)cache.get((Object)key, loader);
        }
        catch (Exception e) {
            SnowRealMagic.LOGGER.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void invalidateAll() {
        VISUAL.invalidateAll();
        COLLIDER.invalidateAll();
        OUTLINE.invalidateAll();
    }

    public record Key(class_2680 state, int layers) {
    }
}

