/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.config;

import com.epherical.croptopia.common.generator.PlacedFeatureKeys;
import com.epherical.croptopia.config.TreeConfiguration;
import com.epherical.epherolib.config.CommonConfig;
import com.epherical.epherolib.libs.org.spongepowered.configurate.CommentedConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.ScopedConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.SerializationException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_7924;

public class CroptopiaConfig
extends CommonConfig {
    public boolean generateSaltInWorld = true;
    public List<TreeConfiguration> treeConfigurations = new ArrayList<TreeConfiguration>();
    public TreeMultimap<class_5321<class_1959>, TreeConfiguration> treeMap = TreeMultimap.create(Comparator.comparing(class_5321::toString), Comparator.comparing(o -> o.getFeatureKey().toString()));
    public boolean rightClickHarvest = true;

    public CroptopiaConfig(AbstractConfigurationLoader.Builder<?, ?> loaderBuilder, String configName) {
        super(loaderBuilder, configName);
    }

    public void parseConfig(CommentedConfigurationNode node) {
        this.configVersion = ((CommentedConfigurationNode)node.node(new Object[]{"version"})).getInt(this.configVersion);
        this.generateSaltInWorld = ((CommentedConfigurationNode)node.node(new Object[]{"generateSaltInWorld"})).getBoolean(this.generateSaltInWorld);
        this.rightClickHarvest = ((CommentedConfigurationNode)node.node(new Object[]{"rightCLickHarvest"})).getBoolean(this.rightClickHarvest);
        try {
            this.treeConfigurations = ((CommentedConfigurationNode)node.node(new Object[]{"treeConfig"})).getList(TreeConfiguration.class);
            if (this.treeConfigurations == null) {
                this.treeConfigurations = new ArrayList<TreeConfiguration>();
            }
            for (TreeConfiguration treeConfiguration : this.treeConfigurations) {
                for (class_5321<class_1959> biomeResourceKey : treeConfiguration.getTreesAllowedInBiome()) {
                    this.treeMap.put(biomeResourceKey, (Object)treeConfiguration);
                }
            }
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    public CommentedConfigurationNode generateConfig(CommentedConfigurationNode node) {
        try {
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"version"})).set((Object)this.configVersion)).comment("Config Version, don't edit");
            ((CommentedConfigurationNode)node.node(new Object[]{"generateSaltInWorld"})).set((Object)this.generateSaltInWorld);
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"rightClickHarvest"})).set((Object)this.rightClickHarvest)).set((Object)"Determines whether or not right click harvesting works (forge only)");
            this.generateTreeConfig(node, "treeConfig");
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        return node;
    }

    private void generateTreeConfig(CommentedConfigurationNode node, String nodeToAdd) {
        List<class_5321<class_1959>> forestBiomes = Arrays.asList(class_1972.field_9409, class_1972.field_35120, class_1972.field_9414);
        List<class_5321<class_1959>> jungleBiomes = Arrays.asList(class_1972.field_9417, class_1972.field_35118);
        List<class_5321<class_1959>> plainsKeys = Arrays.asList(class_1972.field_9451, class_1972.field_9455);
        List<class_5321<class_1959>> darkForestKeys = Arrays.asList(class_1972.field_9475);
        HashMultimap biomes = HashMultimap.create();
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, forestBiomes, PlacedFeatureKeys.LIME_TREE_PLACED_KEY, PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.APRICOT_TREE_PLACED_KEY, PlacedFeatureKeys.AVOCADO_TREE_PLACED_KEY, PlacedFeatureKeys.STARFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.LEMON_TREE_PLACED_KEY, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.ORANGE_TREE_PLACED_KEY, PlacedFeatureKeys.NECTARINE_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, jungleBiomes, PlacedFeatureKeys.DATE_TREE_PLACED_KEY, PlacedFeatureKeys.DRAGONFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.MANGO_TREE_PLACED_KEY, PlacedFeatureKeys.NUTMEG_TREE_PLACED_KEY, PlacedFeatureKeys.COCONUT_TREE_PLACED_KEY, PlacedFeatureKeys.KUMQUAT_TREE_PLACED_KEY, PlacedFeatureKeys.GRAPEFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.BANANA_TREE_PLACED_KEY, PlacedFeatureKeys.FIG_TREE_PLACED_KEY, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, plainsKeys, PlacedFeatureKeys.APPLE_TREE_PLACED_KEY, PlacedFeatureKeys.ORANGE_TREE_PLACED_KEY, PlacedFeatureKeys.PEACH_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, darkForestKeys, PlacedFeatureKeys.ALMOND_TREE_PLACED_KEY, PlacedFeatureKeys.CASHEW_TREE_PLACED_KEY, PlacedFeatureKeys.PECAN_TREE_PLACED_KEY, PlacedFeatureKeys.WALNUT_TREE_PLACED_KEY);
        class_5321 woodlands = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.travID("woodlands"));
        class_5321 wooded_plateau = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.travID("wooded_plateau"));
        class_5321 wooded_island = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.travID("wooded_island"));
        class_5321 autumnal_woods = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.travID("autumnal_woods"));
        class_5321 autumnal_wooded_hills = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.travID("autumnal_wooded_hills"));
        class_5321 lush_swamp = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.travID("lush_swamp"));
        class_5321 mini_jungle = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.travID("mini_jungle"));
        List<class_5321<class_1959>> wooded = Arrays.asList(wooded_island, wooded_plateau, woodlands);
        List<class_5321<class_1959>> autumnal = Arrays.asList(autumnal_woods, autumnal_wooded_hills);
        List<class_5321<class_1959>> jungle = Arrays.asList(mini_jungle);
        List<class_5321<class_1959>> lush = Arrays.asList(lush_swamp);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, wooded, PlacedFeatureKeys.APPLE_TREE_PLACED_KEY, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, autumnal, PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, jungle, PlacedFeatureKeys.DATE_TREE_PLACED_KEY, PlacedFeatureKeys.DRAGONFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.MANGO_TREE_PLACED_KEY, PlacedFeatureKeys.NUTMEG_TREE_PLACED_KEY, PlacedFeatureKeys.COCONUT_TREE_PLACED_KEY, PlacedFeatureKeys.KUMQUAT_TREE_PLACED_KEY, PlacedFeatureKeys.GRAPEFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.BANANA_TREE_PLACED_KEY, PlacedFeatureKeys.FIG_TREE_PLACED_KEY, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, lush, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        class_5321 aspenForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("aspen_forest"));
        class_5321 autumnalValley = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("autumnal_valley"));
        class_5321 bayou = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("bayou"));
        class_5321 blackForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("black_forest"));
        class_5321 canadianShield = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("canadian_shield"));
        class_5321 cherryBlossomForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("cherry_blossom_forest"));
        class_5321 cikaWoods = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("cika_woods"));
        class_5321 coniferousForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("coniferous_forest"));
        class_5321 cragGardens = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("crag_gardens"));
        class_5321 cypressSwamplands = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("cypress_swamplands"));
        class_5321 deadSea = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("dead_sea"));
        class_5321 daciteRidges = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("dacite_ridges"));
        class_5321 windsweptDunes = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("windswept_dunes"));
        class_5321 ebonyWoods = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("ebony_woods"));
        class_5321 forgottenForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("forgotten_forest"));
        class_5321 grove = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("temperate_grove"));
        class_5321 guianaShield = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("guiana_shield"));
        class_5321 jacarandaForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("jacaranda_forest"));
        class_5321 mapleTaiga = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("maple_taiga"));
        class_5321 coconinoMeadow = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("coconino_meadow"));
        class_5321 mojaveDesert = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("mojave_desert"));
        class_5321 lushTundra = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("lush_tundra"));
        class_5321 orchard = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("orchard"));
        class_5321 prairie = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("prairie"));
        class_5321 redOakForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("red_oak_forest"));
        class_5321 redRockValley = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("red_rock_valley"));
        class_5321 roseFields = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("rose_fields"));
        class_5321 autumnalForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("autumnal_forest"));
        class_5321 autumnalTaiga = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("autumnal_taiga"));
        class_5321 shatteredGlacier = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("shattered_glacier"));
        class_5321 firecrackerShrubland = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("firecracker_shrubland"));
        class_5321 sierraBadlands = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("sierra_badlands"));
        class_5321 skyrisVale = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("skyris_vale"));
        class_5321 redwoodThicket = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("redwood_thicket"));
        class_5321 frostedTaiga = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("frosted_taiga"));
        class_5321 frostedConiferousForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("frosted_coniferous_forest"));
        class_5321 fragmentForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("fragment_forest"));
        class_5321 tropicalIsland = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("tropical_islands"));
        class_5321 tropicalRainforest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("tropical_rainforest"));
        class_5321 twilightMeadow = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("twilight_meadow"));
        class_5321 weepingWitchForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("weeping_witch_forest"));
        class_5321 whiteMangroveMarshes = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("white_mangrove_marshes"));
        class_5321 temperateRainforest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("temperate_rainforest"));
        class_5321 zelkovaForest = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CroptopiaConfig.bygID("zelkova_forest"));
        List<class_5321<class_1959>> bygWoods = Arrays.asList(aspenForest, orchard, redOakForest);
        List<class_5321<class_1959>> cherry = Arrays.asList(cherryBlossomForest);
        List<class_5321<class_1959>> nutty = Arrays.asList(weepingWitchForest, daciteRidges, ebonyWoods, mapleTaiga, twilightMeadow);
        List<class_5321<class_1959>> jungleByg = Arrays.asList(cragGardens, tropicalIsland, tropicalRainforest);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, Collections.singleton(prairie), PlacedFeatureKeys.APPLE_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, Arrays.asList(jacarandaForest, autumnalForest, autumnalTaiga), PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, Arrays.asList(cypressSwamplands, whiteMangroveMarshes, temperateRainforest), PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, jungleByg, PlacedFeatureKeys.DATE_TREE_PLACED_KEY, PlacedFeatureKeys.DRAGONFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.MANGO_TREE_PLACED_KEY, PlacedFeatureKeys.NUTMEG_TREE_PLACED_KEY, PlacedFeatureKeys.COCONUT_TREE_PLACED_KEY, PlacedFeatureKeys.KUMQUAT_TREE_PLACED_KEY, PlacedFeatureKeys.GRAPEFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.BANANA_TREE_PLACED_KEY, PlacedFeatureKeys.FIG_TREE_PLACED_KEY, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, nutty, PlacedFeatureKeys.ALMOND_TREE_PLACED_KEY, PlacedFeatureKeys.CASHEW_TREE_PLACED_KEY, PlacedFeatureKeys.PECAN_TREE_PLACED_KEY, PlacedFeatureKeys.WALNUT_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, cherry, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<class_5321<class_6796>, class_5321<class_1959>>)biomes, bygWoods, PlacedFeatureKeys.LIME_TREE_PLACED_KEY, PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.APRICOT_TREE_PLACED_KEY, PlacedFeatureKeys.AVOCADO_TREE_PLACED_KEY, PlacedFeatureKeys.STARFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.LEMON_TREE_PLACED_KEY, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.ORANGE_TREE_PLACED_KEY, PlacedFeatureKeys.NECTARINE_TREE_PLACED_KEY);
        ArrayList<TreeConfiguration> allTreeConfigs = new ArrayList<TreeConfiguration>();
        for (Map.Entry entry : biomes.asMap().entrySet()) {
            allTreeConfigs.add(new TreeConfiguration((class_5321<class_6796>)((class_5321)entry.getKey()), (Collection)entry.getValue()));
        }
        ScopedConfigurationNode node1 = node.node(new Object[]{nodeToAdd});
        try {
            node1.setList(TreeConfiguration.class, allTreeConfigs);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    private static class_2960 travID(String name) {
        return class_2960.method_60655((String)"traverse", (String)name);
    }

    private static class_2960 bygID(String name) {
        return class_2960.method_60655((String)"byg", (String)name);
    }
}

