/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.ArmorStandChances;
import com.yungnickyoung.minecraft.yungsapi.world.processor.StructureEntityProcessor;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ArmorStandProcessor
extends StructureEntityProcessor {
    public static final ArmorStandProcessor INSTANCE = new ArmorStandProcessor();
    public static final MapCodec<class_3491> CODEC = MapCodec.unit(() -> INSTANCE);

    public class_3499.class_3502 processEntity(class_5425 serverLevelAccessor, class_2338 structurePiecePos, class_2338 structurePieceBottomCenterPos, class_3499.class_3502 localEntityInfo, class_3499.class_3502 globalEntityInfo, class_3492 structurePlaceSettings) {
        if (globalEntityInfo.field_15598.method_10558("id").equals("minecraft:armor_stand")) {
            String helmetString;
            String chestplateString;
            String leggingsString;
            String bootsString;
            String helmet;
            class_2499 armorItems = globalEntityInfo.field_15598.method_10554("ArmorItems", 10);
            class_5819 randomSource = structurePlaceSettings.method_15115(globalEntityInfo.field_15600);
            try {
                helmet = ((class_2487)armorItems.method_10534(3)).method_10580("id").toString();
            }
            catch (Exception e) {
                BetterDesertTemplesCommon.LOGGER.info("Unable to randomize armor stand at {}. Missing helmet?", (Object)globalEntityInfo.field_15600);
                return globalEntityInfo;
            }
            boolean isArmory = helmet.equals("\"minecraft:iron_helmet\"");
            class_2487 newNBT = globalEntityInfo.field_15598.method_10553();
            class_2499 armorItemsList = newNBT.method_10554("ArmorItems", 10);
            String string = bootsString = isArmory ? class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getArmoryBoots(randomSource)).toString() : class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getWardrobeBoots(randomSource)).toString();
            if (!bootsString.equals("minecraft:air")) {
                armorItemsList.method_10602(0).method_10582("id", bootsString);
                armorItemsList.method_10602(0).method_10567("Count", (byte)1);
                armorItemsList.method_10602(0).method_10566("tag", (class_2520)class_156.method_654((Object)new class_2487(), compoundTag -> compoundTag.method_10569("Damage", 0)));
            }
            String string2 = leggingsString = isArmory ? class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getArmoryLeggings(randomSource)).toString() : class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getWardrobeLeggings(randomSource)).toString();
            if (!leggingsString.equals("minecraft:air")) {
                armorItemsList.method_10602(1).method_10582("id", leggingsString);
                armorItemsList.method_10602(1).method_10567("Count", (byte)1);
                armorItemsList.method_10602(1).method_10566("tag", (class_2520)class_156.method_654((Object)new class_2487(), compoundTag -> compoundTag.method_10569("Damage", 0)));
            }
            String string3 = chestplateString = isArmory ? class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getArmoryChestplate(randomSource)).toString() : class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getWardrobeChestplate(randomSource)).toString();
            if (!chestplateString.equals("minecraft:air")) {
                armorItemsList.method_10602(2).method_10582("id", chestplateString);
                armorItemsList.method_10602(2).method_10567("Count", (byte)1);
                armorItemsList.method_10602(2).method_10566("tag", (class_2520)class_156.method_654((Object)new class_2487(), compoundTag -> compoundTag.method_10569("Damage", 0)));
            }
            String string4 = helmetString = isArmory ? class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getArmoryHelmet(randomSource)).toString() : class_7923.field_41178.method_10221((Object)ArmorStandChances.get().getWardrobeHelmet(randomSource)).toString();
            if (!helmetString.equals("minecraft:air")) {
                armorItemsList.method_10602(3).method_10582("id", helmetString);
                armorItemsList.method_10602(3).method_10567("Count", (byte)1);
                armorItemsList.method_10602(3).method_10566("tag", (class_2520)class_156.method_654((Object)new class_2487(), compoundTag -> compoundTag.method_10569("Damage", 0)));
            }
            globalEntityInfo = new class_3499.class_3502(globalEntityInfo.field_15599, globalEntityInfo.field_15600, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 structurePlacementData) {
        return blockInfoGlobal;
    }

    protected class_3828<?> method_16772() {
        return StructureProcessorModule.ARMOR_STAND_PROCESSOR;
    }
}

