/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.input.MouseDragHelper;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
final class TWidgetHudElement
extends TElement {
    private static final int GRID_CELL_SIZE = 4;
    protected final TElement target;

    public TWidgetHudElement(TElement target) {
        super(target.getX(), target.getY(), target.getWidth(), target.getHeight());
        if (target.getParent() != null) {
            throw new IllegalArgumentException("Target must not have a parent.");
        }
        this.target = target;
        this.addChild(target, false);
        this.addChild(new MouseCaptureElement(), true);
    }

    @Override
    public final boolean isFocusable() {
        return true;
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
    }

    private final class MouseCaptureElement
    extends TElement {
        private final MouseDragHelper mdh;

        public MouseCaptureElement() {
            super(0, 0, TWidgetHudElement.this.width, TWidgetHudElement.this.height);
            this.setZOffset(TWidgetHudElement.this.target.getZOffset() + 0.1f);
            this.mdh = new MouseDragHelper(){

                @Override
                protected void apply(int deltaX, int deltaY) {
                    TWidgetHudElement.this.move(deltaX, deltaY);
                }
            };
            this.eContextMenu.register((__, cMenu) -> TWidgetHudElement.this.target.eContextMenu.invoker().invoke(TWidgetHudElement.this.target, cMenu));
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        @Virtual
        public void render(TDrawContext pencil) {
        }

        @Override
        @Virtual
        public void postRender(TDrawContext pencil) {
            if (TWidgetHudElement.this.isFocused() || this.isHovered()) {
                pencil.drawTBorder(-1);
            }
        }

        @Override
        @Virtual
        public boolean input(TInputContext inputContext) {
            switch (inputContext.getInputType()) {
                case MOUSE_PRESS: {
                    TContextMenuPanel cm;
                    if (inputContext.getMouseButton() == 1 && (cm = this.createContextMenu()) != null) {
                        cm.open();
                    }
                    return true;
                }
                case MOUSE_DRAG: {
                    if (inputContext.getMouseButton() != 0) break;
                    return this.mdh.onMouseDrag(inputContext.getMouseDelta());
                }
                case MOUSE_DRAG_END: {
                    this.mdh.clear();
                    int gridSize = 4;
                    int x = TWidgetHudElement.this.getX();
                    int y = TWidgetHudElement.this.getY();
                    x = Math.round((float)x / 4.0f) * 4;
                    y = Math.round((float)y / 4.0f) * 4;
                    TWidgetHudElement.this.setPosition(x, y, false);
                    MouseDragHelper.snapToParentBounds(TWidgetHudElement.this);
                    return true;
                }
            }
            return false;
        }
    }
}

