/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TClickableWidget;
import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProviderSetter;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TTextFieldWidget
extends TClickableWidget
implements ITextProviderSetter {
    protected String __text = "";
    protected class_2561 __displayText = TextUtils.literal("");
    protected int __displayTextWidth = 0;
    protected class_2561 __placeholderText;
    public final TEvent<TTextFieldWidgetEvent_TextChanged> eTextChanged = TEventFactory.createLoop(new TTextFieldWidgetEvent_TextChanged[0]);

    public TTextFieldWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    @Virtual
    public boolean isFocusable() {
        return true;
    }

    @Override
    @Virtual
    protected void onClick() {
    }

    @Override
    @Deprecated
    public final class_2561 getText() {
        return this.__displayText;
    }

    @Override
    @Deprecated
    public final void setText(class_2561 text) {
        this.setInput(text != null ? text.getString() : "");
    }

    public final String getInput() {
        return this.__text;
    }

    public final void setInput(String text) {
        this.setInput(text, true);
    }

    public final void setInput(String text, boolean invokeEvent) {
        if (Objects.equals(text = this.sanitizeInput(text), this.__text)) {
            return;
        }
        this.__text = text;
        this.__displayText = TextUtils.literal(text);
        this.__displayTextWidth = TCDCommonsClient.MC_CLIENT.field_1772.method_27525((class_5348)this.__displayText);
        if (invokeEvent) {
            this.eTextChanged.invoker().invoke(this, this.__text);
        }
    }

    @Nullable
    public final class_2561 getPlaceholderText() {
        return this.__placeholderText;
    }

    public final void setPlaceholderText(@Nullable class_2561 text) {
        this.__placeholderText = text;
    }

    @Virtual
    protected String sanitizeInput(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!this.isCharacterAllowed(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @Virtual
    public boolean isCharacterAllowed(char c) {
        return true;
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        if (this.getParentTScreen() == null) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (inputContext.getInputType()) {
            case CHAR_TYPE: {
                return this.inputChar(inputContext.getTypedChar().charValue());
            }
            case KEY_PRESS: {
                int keyCode = inputContext.getKeyboardKey().keyCode;
                if (keyCode == 259 || keyCode == 261) {
                    this.inputBackspace(keyCode == 261);
                } else if (class_437.method_25442() && (keyCode == 257 || keyCode == 335)) {
                    this.click(false);
                } else {
                    return false;
                }
                return true;
            }
            case MOUSE_PRESS: {
                if (inputContext.getMouseButton() != 0) break;
                this.click(false);
                return true;
            }
        }
        return false;
    }

    public final boolean inputChar(char character) {
        if (!this.isCharacterAllowed(character)) {
            return false;
        }
        return this.inputText(Character.toString(character));
    }

    @Virtual
    public boolean inputText(String text) {
        this.setInput(this.__text + text);
        return true;
    }

    public final boolean inputBackspace(boolean isDelete) {
        if (StringUtils.isEmpty((CharSequence)this.__text)) {
            return false;
        }
        if (isDelete) {
            return false;
        }
        this.setInput(this.__text.substring(0, this.__text.length() - 1));
        return true;
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        pencil.drawTFill(-16777216);
        this.renderText(pencil);
    }

    @Virtual
    protected void renderText(TDrawContext pencil) {
        HorizontalAlignment align;
        pencil.method_44379(this.getX(), this.getY(), this.getEndX(), this.getEndY());
        HorizontalAlignment horizontalAlignment = align = this.__displayTextWidth < this.getWidth() - 6 ? HorizontalAlignment.LEFT : HorizontalAlignment.RIGHT;
        if (this.__text.length() > 0) {
            pencil.drawTElementTextTH(this.__displayText, align);
        } else {
            pencil.drawTElementTextTHC(this.__placeholderText, align, -10132123);
        }
        pencil.method_44380();
    }

    @Override
    @Virtual
    public void postRender(TDrawContext pencil) {
        if (this.getParentTScreen().getFocusedElement() == this) {
            pencil.drawTBorder(-1);
        } else {
            pencil.drawTBorder(0x50FFFFFF);
        }
    }

    public static interface TTextFieldWidgetEvent_TextChanged {
        public void invoke(TTextFieldWidget var1, String var2);
    }
}

